/*
 * Decompiled with CFR 0.152.
 */
package io.github.andreyzebin.gitSql.git2;

import io.github.andreyzebin.gitSql.bash.Bash;
import io.github.andreyzebin.gitSql.git.VersionControl;
import io.github.andreyzebin.gitSql.git2.GitBindings;
import io.github.andreyzebin.gitSql.git2.TerminalIO;
import java.nio.file.Path;
import java.time.Instant;
import java.util.Optional;
import java.util.stream.Stream;

public abstract class AbstractVersionControl
implements VersionControl {
    protected final TerminalIO term;
    private Optional<String> origin = null;

    protected AbstractVersionControl(TerminalIO term) {
        this.term = term;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VersionControl seek(String commit) {
        String pwd = this.term.eval("pwd");
        try {
            this.term.eval("cd " + Bash.escape(Bash.posix(this.getRoot())));
            GitBindings.checkout(commit, this.term);
            AbstractVersionControl abstractVersionControl = this;
            return abstractVersionControl;
        }
        finally {
            this.term.eval("cd " + pwd);
        }
    }

    public Stream<VersionControl.Commit> commits() {
        String pwd = this.term.eval("pwd");
        try {
            this.term.eval("cd " + Bash.escape(Bash.posix(this.getRoot())));
            Stream<VersionControl.Commit> stream = GitBindings.commitsList(this.term);
            return stream;
        }
        finally {
            this.term.eval("cd " + pwd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Stream<? extends VersionControl.Change> changes(String hashFrom) {
        String pwd = this.term.eval("pwd");
        try {
            this.term.eval("cd " + Bash.escape(Bash.posix(this.getRoot())));
            Stream<VersionControl.Change> stream = GitBindings.filesChangedQuery("", GitBindings.sinceHash(hashFrom), this.term);
            return stream;
        }
        finally {
            this.term.eval("cd " + pwd);
        }
    }

    @Override
    public Instant timestamp() {
        String pwd = this.term.eval("pwd");
        try {
            this.term.eval("cd " + Bash.escape(Bash.posix(this.getRoot())));
            Instant instant = GitBindings.commitsList(this.term).findFirst().get().getTimestampInstant();
            return instant;
        }
        finally {
            this.term.eval("cd " + pwd);
        }
    }

    public Optional<String> origin() {
        String pwd = this.term.eval("pwd");
        try {
            if (this.origin == null) {
                this.term.eval("cd " + Bash.escape(Bash.posix(this.getRoot())));
                this.origin = GitBindings.getOrigin(this.term);
            }
            Optional<String> optional = this.origin;
            return optional;
        }
        finally {
            this.term.eval("cd " + pwd);
        }
    }

    public Optional<String> branch() {
        String pwd = this.term.eval("pwd");
        try {
            this.term.eval("cd " + Bash.escape(Bash.posix(this.getRoot())));
            Optional<String> optional = GitBindings.getBranch(this.term);
            return optional;
        }
        finally {
            this.term.eval("cd " + pwd);
        }
    }

    public abstract Path getRoot();
}

