/*
 * Decompiled with CFR 0.152.
 */
package io.github.andreyzebin.gitSql.git2;

import java.util.function.Consumer;

public class LineWriter
implements AutoCloseable {
    private StringBuilder sb = new StringBuilder();
    private final Consumer<String> lines;

    public LineWriter(Consumer<String> lines) {
        this.lines = lines;
    }

    public void println(String line) {
        this.print(line);
        this.newLine();
    }

    public void newLine() {
        this.print(System.lineSeparator());
    }

    public void print(String segment) {
        int fromIndex = 0;
        int indexOf = segment.indexOf(System.lineSeparator(), fromIndex);
        while (indexOf != -1) {
            this.sb.append(segment.substring(fromIndex, indexOf));
            this.lines.accept(this.sb.toString());
            this.sb.setLength(0);
            fromIndex = indexOf + 1;
            indexOf = segment.indexOf(System.lineSeparator(), fromIndex);
        }
        this.sb.append(segment.substring(fromIndex, segment.length()));
    }

    @Override
    public void close() throws Exception {
        if (!this.sb.isEmpty()) {
            this.lines.accept(this.sb.toString());
            this.sb.setLength(0);
        }
    }
}

