/*
 * Decompiled with CFR 0.152.
 */
package io.github.zebin.javabash.sandbox;

import io.github.zebin.javabash.process.TextTerminal;
import io.github.zebin.javabash.sandbox.PosixPath;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class TerminalSandBox {
    private final TextTerminal delegate;

    public TerminalSandBox(TextTerminal delegate) {
        this.delegate = delegate;
    }

    public PosixPath pwd() {
        return PosixPath.ofPosix(this.delegate.eval("pwd"));
    }

    public PosixPath up() {
        this.delegate.eval("cd ..");
        return this.pwd();
    }

    public String cat(PosixPath pp) {
        return this.delegate.eval(String.format("cat %s", pp));
    }

    public PosixPath touch(PosixPath newDir) {
        this.delegate.eval(String.format("touch %s", newDir));
        return newDir.isAbsolute() ? newDir : this.pwd().climb(newDir);
    }

    public List<PosixPath> listDir() {
        String eval = this.delegate.eval("ls -a");
        return eval.lines().map(PosixPath::ofPosix).collect(Collectors.toList());
    }

    public PosixPath makeDir(PosixPath newDir) {
        this.delegate.eval(String.format("mkdir %s", newDir));
        return newDir.isAbsolute() ? newDir : this.pwd().climb(newDir);
    }

    public boolean exists(PosixPath newDir) {
        return this.delegate.eval(String.format("if [ -d %s ]; then\n  echo \"YES\"\nfi", newDir)).contains("YES");
    }

    public boolean isFolder(PosixPath newDir) {
        return this.delegate.eval(String.format("if [ -d %s ]; then\n  echo \"YES\"\nfi", newDir)).contains("YES");
    }

    public boolean isFile(PosixPath newDir) {
        return this.exists(newDir) && !this.isFolder(newDir);
    }

    public PosixPath removeDir(PosixPath newDir) {
        this.delegate.eval(String.format("rm -rf %s", newDir));
        return newDir.isAbsolute() ? newDir : this.pwd().climb(newDir);
    }

    private static void openSecret(TextTerminal bash, String key, String value) {
        bash.eval(String.format("%s=%s", key, value), String.format("%s=***", key));
    }

    private static void closeSecret(TextTerminal bash, String key) {
        bash.eval(String.format("%s=''", key), String.format("%s=''", key));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T withSecret(TextTerminal bash, String key, String value, Supplier<T> result) {
        try {
            TerminalSandBox.openSecret(bash, key, value);
            T t = result.get();
            return t;
        }
        finally {
            TerminalSandBox.closeSecret(bash, key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T lockDir(TextTerminal bash, Supplier<T> result) {
        String pwd = bash.eval("pwd");
        try {
            T t = result.get();
            return t;
        }
        finally {
            bash.eval("cd " + pwd);
        }
    }

    public static void lockDir(TextTerminal bash, Runnable action) {
        Integer v = TerminalSandBox.lockDir(bash, () -> {
            action.run();
            return 0;
        });
    }
}

