/*
 * Decompiled with CFR 0.152.
 */
package io.github.zebin.javabash.sandbox;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class PosixPath
implements Iterable<PosixPath> {
    public static final PosixPath CURRENT = PosixPath.ofPosix(".");
    public static final PosixPath LEVEL_UP = PosixPath.ofPosix("..");
    private final String[] segments;
    private final int start;
    private final int endInclusive;
    private final boolean isAbsolute;

    private PosixPath(int start, int endInclusive, boolean isAbsolute, String ... segments) {
        this.segments = segments;
        this.start = start;
        this.endInclusive = endInclusive;
        this.isAbsolute = isAbsolute;
    }

    public Path toPath() {
        return this.length() > 0 ? (this.isAbsolute ? Path.of(File.separator, Path.of(File.separator, this.segments).subpath(0, this.endInclusive + 1).toString()) : Path.of("", this.segments).subpath(0, this.endInclusive + 1)) : (this.isAbsolute ? Path.of(File.separator, new String[0]) : Path.of("", new String[0]));
    }

    public int length() {
        return this.endInclusive - this.start + 1;
    }

    public String toString() {
        return (this.isAbsolute ? "/" : "") + StreamSupport.stream(Arrays.spliterator(this.segments, this.start, this.endInclusive + 1), false).collect(Collectors.joining("/"));
    }

    @Override
    public Iterator<PosixPath> iterator() {
        return new Iterator<PosixPath>(){
            private PosixPath it;
            {
                this.it = PosixPath.this;
            }

            @Override
            public boolean hasNext() {
                return this.it != null;
            }

            @Override
            public PosixPath next() {
                PosixPath it1 = this.it;
                this.it = it1.hasSegments() ? it1.descend() : null;
                return it1;
            }
        };
    }

    public static PosixPath root() {
        return new PosixPath(0, -1, true, new String[0]);
    }

    public static PosixPath relate() {
        return new PosixPath(0, -1, false, new String[0]);
    }

    public PosixPath descend() {
        return new PosixPath(this.start, this.endInclusive - 1, this.isAbsolute, this.segments);
    }

    public static PosixPath ofPosix(String posix) {
        if (posix.startsWith("/")) {
            return PosixPath.root().climb((String[])Arrays.stream(posix.split("/")).skip(1L).filter(s -> !s.isBlank()).toArray(String[]::new));
        }
        return PosixPath.relate().climb((String[])Arrays.stream(posix.split("/")).filter(s -> !s.isBlank()).toArray(String[]::new));
    }

    public boolean startsWith(PosixPath pp) {
        PosixPath temp = this;
        while (temp.length() > pp.length()) {
            temp = temp.descend();
        }
        return temp.equals(pp);
    }

    public boolean endsWith(PosixPath pp) {
        if (pp.isAbsolute()) {
            return false;
        }
        PosixPath temp = this;
        while (temp.length() + pp.length() > this.length()) {
            temp = temp.descend();
        }
        return temp.climb(pp).equals(this);
    }

    public static PosixPath of(Path path) {
        ArrayList list = new ArrayList();
        path.iterator().forEachRemaining(k -> {
            if (!k.toString().isBlank()) {
                list.add(k.toString());
            }
        });
        if (path.isAbsolute()) {
            return PosixPath.root().climb((String[])list.toArray(String[]::new));
        }
        return PosixPath.relate().climb((String[])list.toArray(String[]::new));
    }

    public PosixPath climb(String ... suffix) {
        for (String seg : suffix) {
            if (seg.contains("/") || seg.contains("\\")) {
                throw new IllegalArgumentException("Wrong argument: Segment must not contain path separators!");
            }
            if (seg.isBlank()) {
                throw new IllegalArgumentException("Wrong argument: Segment must not be blank!");
            }
            if (seg.trim().equals(seg)) continue;
            throw new IllegalArgumentException("Wrong argument: Segment must not contain leading or trailing spaces!");
        }
        String[] dest = new String[this.length() + suffix.length];
        System.arraycopy(this.segments, this.start, dest, 0, this.length());
        System.arraycopy(suffix, 0, dest, this.length(), suffix.length);
        return new PosixPath(0, this.length() + suffix.length - 1, this.isAbsolute, dest);
    }

    public PosixPath climb(PosixPath suffix) {
        if (suffix.isAbsolute) {
            throw new IllegalArgumentException("Wrong argument: Can not append another absolute path!");
        }
        return this.climb(suffix.segments);
    }

    private boolean hasSegments() {
        return this.start < this.endInclusive + 1;
    }

    public boolean isAbsolute() {
        return this.isAbsolute;
    }

    public Stream<PosixPath> descendStream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PosixPath posixPath = (PosixPath)o;
        return this.toString().equals(posixPath.toString());
    }

    public int hashCode() {
        return PosixPath.arrayHashCode(this.segments, this.start, this.endInclusive);
    }

    private static int arrayHashCode(Object[] a, int start, int end) {
        if (a == null) {
            return 0;
        }
        int result = 1;
        for (int i = start; i < end; ++i) {
            Object element = a[i];
            result = 31 * result + (element == null ? 0 : element.hashCode());
        }
        return result;
    }
}

