package io.github.andreyzebin.gitSql.git;

import io.github.zebin.javabash.sandbox.PosixPath;

import java.nio.file.Path;
import java.util.Optional;

public interface GitSource extends AutoCloseable {

    Path getRoot();

    default PosixPath getLocation() {
        return PosixPath.of(getRoot());
    }

    void flush();

    void pull();

    Optional<String> origin();

    Optional<String> branch();
}
