/*
 * Decompiled with CFR 0.152.
 */
package io.github.andreyzebin.gitSql.config;

import io.github.zebin.javabash.sandbox.DirectoryTree;
import io.github.zebin.javabash.sandbox.PosixPath;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Stream;

public class ConfigTree {
    private final DirectoryTree dt;

    public ConfigTree(DirectoryTree delegate) {
        this.dt = delegate;
    }

    public Stream<PosixPath> getLeafs() {
        LinkedList propLeafs = new LinkedList();
        this.dt.traverse(PosixPath.ofPosix((String)""), d -> {
            boolean hasPropertyMarker = this.dt.list(d).anyMatch(f -> f.getEnd().equals("conf.properties") && !this.dt.isDir(f));
            if (hasPropertyMarker) {
                propLeafs.add(d);
            }
            return true;
        });
        return propLeafs.stream();
    }

    public Set<String> getPropertyKeys(PosixPath leaf) {
        return this.getProperties(leaf).keySet();
    }

    private Map<String, String> getProperties(PosixPath leaf) {
        HashMap<String, String> effProps = new HashMap<String, String>();
        leaf.streamClimbing().forEach(pp -> {
            PosixPath currProp = pp.climb(new String[]{"conf.properties"});
            if (this.dt.exists(currProp) && !this.dt.isDir(currProp)) {
                Properties prop = new Properties();
                try {
                    prop.load(this.dt.get(currProp));
                    prop.stringPropertyNames().forEach(pr -> effProps.put((String)pr, prop.getProperty((String)pr)));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
        return effProps;
    }

    public String getProperty(PosixPath leaf, String key) {
        return this.getProperties(leaf).get(key);
    }

    public Optional<String> setProperty(PosixPath leaf, String key, String value) {
        Optional<String> ret;
        block18: {
            PosixPath currProp = leaf.climb(new String[]{"conf.properties"});
            boolean hasFile = this.dt.exists(currProp) && !this.dt.isDir(currProp);
            ret = Optional.empty();
            if (hasFile) {
                Properties prop = new Properties();
                try {
                    prop.load(this.dt.get(currProp));
                    if (prop.stringPropertyNames().contains(key)) {
                        ret = Optional.ofNullable(prop.getProperty(key));
                    }
                    prop.setProperty(key, value);
                    try (Writer upd = this.dt.put(currProp);){
                        prop.store(upd, "The file was updated via ConfigTree");
                        break block18;
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            try (Writer patch = this.dt.put(currProp);){
                patch.write("The file was generated via ConfigTree");
                patch.write(System.lineSeparator());
                patch.write(String.format("%s=%s", key, value));
                patch.write(System.lineSeparator());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return ret;
    }
}

