/*
 * Decompiled with CFR 0.152.
 */
package io.github.andreyzebin.gitSql.git;

import io.github.andreyzebin.gitSql.git.GitBindings;
import io.github.zebin.javabash.process.TextTerminal;
import java.net.URI;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang3.tuple.Pair;

public interface GitAuth {
    public static final ConcurrentMap<Pair<TextTerminal, String>, String> sshPerTerminal = new ConcurrentHashMap<Pair<TextTerminal, String>, String>();

    default public boolean useAuthHeader() {
        return false;
    }

    default public void beforeRemote(TextTerminal terminal) {
    }

    default public void afterRemote(TextTerminal terminal) {
    }

    default public String injectAuth(String origin) {
        return origin;
    }

    public static GitAuth ofSshAgent(final String key) {
        return new GitAuth(){

            @Override
            public void beforeRemote(TextTerminal terminal) {
                sshPerTerminal.computeIfAbsent(Pair.of((Object)terminal, (Object)key), k -> {
                    terminal.eval("eval `ssh-agent`");
                    GitBindings.sshAgent(key, terminal);
                    return "";
                });
            }
        };
    }

    public static GitAuth empty() {
        return new GitAuth(){};
    }

    public static void openSecret(TextTerminal bash, String key, String value) {
        bash.eval(String.format("%s=%s", key, value), String.format("%s=***", key));
    }

    public static GitAuth userAndToken(final String username, final String token) {
        return new GitAuth(){

            @Override
            public void beforeRemote(TextTerminal terminal) {
                GitAuth.openSecret(terminal, "GIT_USERNAME", username);
                GitAuth.openSecret(terminal, "GIT_TOKEN", token);
            }

            @Override
            public String injectAuth(String origin) {
                URI uri = URI.create(origin);
                return URI.create(uri.getScheme() + "://$GIT_USERNAME:$GIT_TOKEN@" + uri.getRawAuthority() + uri.getRawPath()).toString();
            }
        };
    }

    public static GitAuth ofApiToken(final String token) {
        return new GitAuth(){

            @Override
            public boolean useAuthHeader() {
                return true;
            }

            @Override
            public void beforeRemote(TextTerminal terminal) {
                GitAuth.openSecret(terminal, "API_TOKEN", token);
            }
        };
    }
}

