/*
 * Decompiled with CFR 0.152.
 */
package io.github.andreyzebin.gitSql.git;

import io.github.andreyzebin.gitSql.git.BranchHead;
import io.github.andreyzebin.gitSql.git.VersionControl;
import io.github.zebin.javabash.process.TextTerminal;
import io.github.zebin.javabash.sandbox.BashUtils;
import java.io.StringWriter;
import java.nio.file.Path;
import java.util.Optional;
import java.util.stream.Stream;

public class GitBindings {
    public static final String ALL_BRANCHES = "";
    public static final String NO_MASTER_COMMITS = GitBindings.notBranch("master");

    public static Optional<String> getBranch(TextTerminal bash) {
        StringWriter out = new StringWriter();
        StringWriter err = new StringWriter();
        int exec = bash.exec("git rev-parse --abbrev-ref HEAD", out::append, err::append);
        if (exec != 0) {
            throw new RuntimeException("Could not get branch: " + String.valueOf(err));
        }
        return out.toString().lines().findFirst();
    }

    public static String periodHash(String from, String to) {
        return String.format(" %s..%s ", from, to);
    }

    public static String sinceHash(String from) {
        return GitBindings.periodHash(from, ALL_BRANCHES);
    }

    public static String notBranch(String branch) {
        return String.format("--not %s", branch);
    }

    public static Stream<VersionControl.Change> filesChangedQuery(String branch, String query, TextTerminal bash) {
        StringWriter out = new StringWriter();
        StringWriter err = new StringWriter();
        int exec = bash.exec(String.format("git log %s --name-status %s | grep -E '^[A-Z]\\b' | sort -k 2,2 -u", branch, query), out::append, err::append);
        if (exec != 0) {
            throw new RuntimeException("Could not list changes: " + String.valueOf(err));
        }
        return out.toString().lines().map(cBr -> cBr.replaceAll("\\s", ";")).map(cBr -> cBr.replace(";;", ";")).map(cBr -> cBr.replace(";;", ";")).map(cLine -> VersionControl.Change.builder().type(cLine.split(";")[0]).file(cLine.split(";")[1]).build());
    }

    public static void merge(String headHash, TextTerminal bash) {
        bash.eval(String.format("git merge %s", headHash));
    }

    public static Stream<BranchHead> getRemoteBranches(String origin, TextTerminal bash, boolean authHeader) {
        StringWriter out = new StringWriter();
        bash.exec(String.format("git %s ls-remote --heads %s ", authHeader ? "-c http.extraHeader=\"Authorization: Bearer $API_TOKEN\"" : ALL_BRANCHES, origin), out::append, k -> {});
        return out.toString().lines().map(cBr -> cBr.replaceAll("\\s", ";")).map(cBr -> cBr.replace(";;", ";")).map(cBr -> cBr.replace(";;", ";")).filter(cBr -> cBr.contains("refs/heads/")).map(cBr -> cBr.replace("refs/heads/", ALL_BRANCHES)).map(cBr -> BranchHead.builder().hash(cBr.split(";")[0]).name(cBr.split(";")[1]).build());
    }

    public static void clone(String target, TextTerminal bash, String uri, boolean isQuiet, boolean authHeader, String branch) {
        bash.eval(String.format("git clone -c core.protectNTFS=false %s %s %s %s %s", branch != null ? "--single-branch --branch " + branch : ALL_BRANCHES, authHeader ? "-c http.extraHeader=\"Authorization: Bearer $API_TOKEN\"" : ALL_BRANCHES, uri, isQuiet ? "--quiet" : ALL_BRANCHES, target));
    }

    public static void add(TextTerminal bash, Path relative) {
        bash.eval("git add " + BashUtils.escape((String)BashUtils.toPosix((Path)relative)));
    }

    public static void commit(TextTerminal bash) {
        bash.eval("git commit -a -m \"msg\"");
    }

    public static Stream<VersionControl.Change> listStatus(TextTerminal bash) {
        StringWriter out = new StringWriter();
        StringWriter err = new StringWriter();
        int exec = bash.exec("git status --porcelain --untracked-files=no", out::append, err::append);
        if (exec != 0) {
            throw new RuntimeException("Could not list changes: " + String.valueOf(err));
        }
        return out.toString().lines().map(cBr -> cBr.replaceAll("\\s", ";")).map(cBr -> cBr.replace(";;", ";")).map(cBr -> cBr.replace(";;", ";")).map(cLine -> VersionControl.Change.builder().type(cLine.split(";")[0]).file(cLine.split(";")[1]).build());
    }

    public static boolean hasStatus(TextTerminal bash) {
        return GitBindings.listStatus(bash).findAny().isPresent();
    }

    public static void push(TextTerminal bash) {
        bash.eval("git push ");
    }

    public static void checkout(String hash, TextTerminal bash) {
        bash.eval("git checkout " + hash);
    }

    public static void pull(TextTerminal bash) {
        bash.eval("git pull");
    }

    public static Stream<VersionControl.Commit> commitsList(TextTerminal bash) {
        StringWriter sw = new StringWriter();
        StringWriter err = new StringWriter();
        int exec = bash.exec("git --no-pager log --pretty=%cI,%H ", sw::append, err::append);
        if (exec != 0) {
            throw new RuntimeException("Could not list commits: " + String.valueOf(err));
        }
        return sw.toString().lines().map(cLine -> VersionControl.Commit.builder().timestamp(cLine.split(",")[0]).hash(cLine.split(",")[1]).build());
    }

    public static void sshAgent(String pathOfKey, TextTerminal bash) {
        bash.eval("ssh-add " + (pathOfKey != null ? pathOfKey : ALL_BRANCHES));
    }

    public static Optional<String> getOrigin(TextTerminal bash) {
        StringWriter sw = new StringWriter();
        StringWriter err = new StringWriter();
        int exec = bash.exec("git config --get remote.origin.url", sw::append, err::append);
        if (exec != 0) {
            throw new RuntimeException("Could not get origin: " + String.valueOf(err));
        }
        return sw.toString().lines().findFirst();
    }
}

