/*
 * Decompiled with CFR 0.152.
 */
package io.github.andreyzebin.gitSql.git;

import io.github.andreyzebin.gitSql.git.AbstractVersionControl;
import io.github.andreyzebin.gitSql.git.GitBindings;
import io.github.andreyzebin.gitSql.git.GitVersions;
import io.github.zebin.javabash.process.TextTerminal;
import io.github.zebin.javabash.sandbox.BashUtils;
import io.github.zebin.javabash.sandbox.DirectoryTree;
import io.github.zebin.javabash.sandbox.FileManager;
import io.github.zebin.javabash.sandbox.WorkingDirectory;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalSource
extends AbstractVersionControl
implements GitVersions {
    private static final Logger log = LoggerFactory.getLogger(LocalSource.class);
    private final Path root;
    private final TextTerminal term;
    private StringBuffer stage = new StringBuffer();

    public LocalSource(Path root, TextTerminal term) {
        super(term);
        this.term = term;
        this.root = root.toAbsolutePath();
    }

    public DirectoryTree getDirectory() {
        return new WorkingDirectory(new FileManager(this.term), f -> BashUtils.append((StringBuffer)this.stage, (String)f.getPath().toString()));
    }

    @Override
    public Path getRoot() {
        return this.root;
    }

    @Override
    public void flush() {
        if (!this.stage.toString().isBlank()) {
            BashUtils.lockDir((TextTerminal)this.term, () -> {
                this.term.eval("cd " + BashUtils.encode((Path)this.getRoot()));
                Arrays.stream(this.stage.toString().split(System.lineSeparator())).forEach(cFile -> GitBindings.add(this.term, Path.of(cFile, new String[0])));
                if (GitBindings.hasStatus(this.term)) {
                    GitBindings.commit(this.term);
                } else {
                    log.debug("Status has no changes, skip commit.");
                }
                return 0;
            });
        }
        this.stage = new StringBuffer();
    }

    @Override
    public void pull() {
        String pwd = this.term.eval("pwd");
        try {
            this.term.eval("cd " + BashUtils.encode((Path)this.getRoot()));
            GitBindings.pull(this.term);
        }
        finally {
            this.term.eval("cd " + pwd);
        }
    }

    @Override
    public void close() {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LocalSource that = (LocalSource)o;
        return Objects.equals(this.root, that.root);
    }

    public int hashCode() {
        return Objects.hash(this.root);
    }
}

