/*
 * Decompiled with CFR 0.152.
 */
package io.github.andreyzebin.gitSql.git;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.stream.Stream;

public interface VersionControl {
    public VersionControl seek(String var1);

    public Stream<? extends Commit> commits();

    public Stream<? extends Change> changes(String var1);

    public Instant timestamp();

    public void flush();

    public static class Change {
        private String file;
        private String type;

        @JsonIgnore
        public boolean isDeletion() {
            return this.type.equals("D");
        }

        @JsonIgnore
        public boolean isModification() {
            return this.type.equals("M");
        }

        @JsonIgnore
        public boolean isAddition() {
            return this.type.equals("A");
        }

        @JsonIgnore
        public boolean isUpdate() {
            return this.isAddition() || this.isModification();
        }

        public static ChangeBuilder builder() {
            return new ChangeBuilder();
        }

        public String getFile() {
            return this.file;
        }

        public String getType() {
            return this.type;
        }

        public void setFile(String file) {
            this.file = file;
        }

        public void setType(String type) {
            this.type = type;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Change)) {
                return false;
            }
            Change other = (Change)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$file = this.getFile();
            String other$file = other.getFile();
            if (this$file == null ? other$file != null : !this$file.equals(other$file)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            return !(this$type == null ? other$type != null : !this$type.equals(other$type));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Change;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $file = this.getFile();
            result = result * 59 + ($file == null ? 43 : $file.hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            return result;
        }

        public String toString() {
            return "VersionControl.Change(file=" + this.getFile() + ", type=" + this.getType() + ")";
        }

        public Change(String file, String type) {
            this.file = file;
            this.type = type;
        }

        public Change() {
        }

        public static class ChangeBuilder {
            private String file;
            private String type;

            ChangeBuilder() {
            }

            public ChangeBuilder file(String file) {
                this.file = file;
                return this;
            }

            public ChangeBuilder type(String type) {
                this.type = type;
                return this;
            }

            public Change build() {
                return new Change(this.file, this.type);
            }

            public String toString() {
                return "VersionControl.Change.ChangeBuilder(file=" + this.file + ", type=" + this.type + ")";
            }
        }
    }

    public static class Commit {
        private String hash;
        private String timestamp;

        @JsonIgnore
        public Instant getTimestampInstant() {
            return Instant.from(DateTimeFormatter.ISO_INSTANT.parse(this.timestamp));
        }

        public static CommitBuilder builder() {
            return new CommitBuilder();
        }

        public String getHash() {
            return this.hash;
        }

        public String getTimestamp() {
            return this.timestamp;
        }

        public void setHash(String hash) {
            this.hash = hash;
        }

        public void setTimestamp(String timestamp) {
            this.timestamp = timestamp;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Commit)) {
                return false;
            }
            Commit other = (Commit)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$hash = this.getHash();
            String other$hash = other.getHash();
            if (this$hash == null ? other$hash != null : !this$hash.equals(other$hash)) {
                return false;
            }
            String this$timestamp = this.getTimestamp();
            String other$timestamp = other.getTimestamp();
            return !(this$timestamp == null ? other$timestamp != null : !this$timestamp.equals(other$timestamp));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Commit;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $hash = this.getHash();
            result = result * 59 + ($hash == null ? 43 : $hash.hashCode());
            String $timestamp = this.getTimestamp();
            result = result * 59 + ($timestamp == null ? 43 : $timestamp.hashCode());
            return result;
        }

        public String toString() {
            return "VersionControl.Commit(hash=" + this.getHash() + ", timestamp=" + this.getTimestamp() + ")";
        }

        public Commit(String hash, String timestamp) {
            this.hash = hash;
            this.timestamp = timestamp;
        }

        public Commit() {
        }

        public static class CommitBuilder {
            private String hash;
            private String timestamp;

            CommitBuilder() {
            }

            public CommitBuilder hash(String hash) {
                this.hash = hash;
                return this;
            }

            public CommitBuilder timestamp(String timestamp) {
                this.timestamp = timestamp;
                return this;
            }

            public Commit build() {
                return new Commit(this.hash, this.timestamp);
            }

            public String toString() {
                return "VersionControl.Commit.CommitBuilder(hash=" + this.hash + ", timestamp=" + this.timestamp + ")";
            }
        }
    }
}

