/*
 * Decompiled with CFR 0.152.
 */
package io.github.andreyzebin.gitSql.git;

import io.github.andreyzebin.gitSql.FileSystem;
import io.github.andreyzebin.gitSql.FileSystemSubDirectory;
import io.github.andreyzebin.gitSql.FileSystemUtils;
import io.github.andreyzebin.gitSql.git.GitBindings;
import io.github.andreyzebin.gitSql.git.GitVersions;
import io.github.zebin.javabash.process.TextTerminal;
import io.github.zebin.javabash.sandbox.BashUtils;
import io.github.zebin.javabash.sandbox.PosixPath;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersionedFiles
implements FileSystem {
    private static final Logger log = LoggerFactory.getLogger(VersionedFiles.class);
    private final boolean isReadOnly;
    private final GitVersions source;
    private final TextTerminal term;
    private StringBuffer filesToAdd;

    public VersionedFiles(boolean isReadOnly, GitVersions source, TextTerminal term) {
        this.isReadOnly = isReadOnly;
        this.source = source;
        this.term = term;
        this.filesToAdd = new StringBuffer();
    }

    public GitVersions getSource() {
        return this.source;
    }

    @Override
    public Writer put(Path path) {
        try {
            Path newFile = this.getAbs(path);
            Files.createDirectories(newFile.getParent(), new FileAttribute[0]);
            BashUtils.append((StringBuffer)this.filesToAdd, (String)path.toString());
            return new FileWriter(newFile.toFile(), false);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Path getAbs(Path path) {
        return this.getRoot().resolve(path);
    }

    @Override
    public boolean erase(Path path) {
        if (this.exists(path)) {
            this.term.eval("rm " + BashUtils.encode((Path)this.getAbs(path)));
            return true;
        }
        return false;
    }

    @Override
    public Writer patch(Path path) {
        try {
            Path newFile = this.getAbs(path);
            Files.createDirectories(newFile.getParent(), new FileAttribute[0]);
            BashUtils.append((StringBuffer)this.filesToAdd, (String)path.toString());
            return new FileWriter(newFile.toFile(), true);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Reader get(Path path) {
        try {
            return new FileReader(this.getAbs(path).toFile());
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean exists(Path path) {
        return Files.exists(this.getAbs(path), new LinkOption[0]);
    }

    @Override
    public boolean isDir(Path path) {
        return this.getAbs(path).toFile().isDirectory();
    }

    @Override
    public int run(String cmd, Consumer<String> stdOut, Consumer<String> stdErr) {
        return (Integer)BashUtils.lockDir((TextTerminal)this.term, () -> {
            this.term.eval("cd " + BashUtils.encode((Path)this.getAbs(Path.of("", new String[0]))));
            return this.term.exec(cmd, stdOut, stdErr);
        });
    }

    @Override
    public void find(Function<Path, Boolean> needContinue, Consumer<Path> sayBye, Comparator<Path> sorting) {
        Path root = this.getRoot();
        FileSystemUtils.tVerse(root, p -> (Boolean)needContinue.apply(root.relativize((Path)p)), p -> sayBye.accept(root.relativize((Path)p)), sorting);
    }

    @Override
    public void flush() {
        if (this.isReadOnly) {
            return;
        }
        if (!this.filesToAdd.toString().isBlank()) {
            BashUtils.lockDir((TextTerminal)this.term, () -> {
                this.term.eval("cd " + BashUtils.encode((Path)this.getRoot()));
                Arrays.stream(this.filesToAdd.toString().split(System.lineSeparator())).forEach(cFile -> GitBindings.add(this.term, Path.of(cFile, new String[0])));
                if (GitBindings.hasStatus(this.term)) {
                    GitBindings.commit(this.term);
                    this.term.eval("cd ..");
                    this.source.flush();
                } else {
                    log.debug("Status has no changes, skip commit.");
                }
                return 0;
            });
        }
        this.filesToAdd = new StringBuffer();
    }

    @Override
    public FileSystem subTree(Path jump) {
        return new FileSystemSubDirectory((FileSystem)this, jump);
    }

    @Override
    public void close() throws Exception {
        this.source.close();
    }

    @Override
    public FileSystem subTree(PosixPath jump) {
        return new FileSystemSubDirectory((FileSystem)new VersionedFiles(false, this.getSource(), this.term), jump);
    }

    public Path getRoot() {
        return this.source.getRoot();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VersionedFiles gitFiles = (VersionedFiles)o;
        return Objects.equals(this.source, gitFiles.source);
    }

    public int hashCode() {
        return Objects.hash(this.source);
    }
}

