package io.github.andreyzebin.gitSql.git;


import io.github.zebin.javabash.process.TextTerminal;
import io.github.zebin.javabash.sandbox.BashUtils;
import io.github.zebin.javabash.sandbox.DirectoryTree;
import io.github.zebin.javabash.sandbox.FileManager;
import io.github.zebin.javabash.sandbox.WorkingDirectory;
import lombok.extern.slf4j.Slf4j;

import java.nio.file.Path;
import java.util.Arrays;
import java.util.Objects;

@Slf4j
public class LocalSource extends AbstractClient {

    private final Path root;
    private final TextTerminal term;

    public LocalSource(Path root, TextTerminal term) {
        super(term);
        this.term = term;
        this.root = root.toAbsolutePath();
    }

    @Override
    public Path getRoot() {
        return root;
    }

    @Override
    public void pull() {
        String pwd = term.eval("pwd");
        try {
            term.eval("cd " + BashUtils.encode(getRoot()));
            GitBindings.pull(term);
        } finally {
            term.eval("cd " + pwd);
        }
    }

    @Override
    public void close() {
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        LocalSource that = (LocalSource) o;
        return Objects.equals(root, that.root);
    }

    @Override
    public int hashCode() {
        return Objects.hash(root);
    }
}
