package io.github.andreyzebin.gitSql.sql;

import io.github.andreyzebin.gitSql.git.Commit;
import io.github.andreyzebin.gitSql.git.VersionedFiles;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class GitUtils {

    public static <E> List<E> reversed(List<E> col) {
        final ArrayList<E> es = new ArrayList<>(col);
        Collections.reverse(es);
        return es;
    }

    public static Stream<Commit> getPoints(
            VersionedFiles cDataSet,
            Instant from1, Instant to1
    ) {
        List<Commit> foundPoints = new LinkedList<>();

        final Iterator<? extends Commit> commitsAll = reversed(
                cDataSet.getSource().listCommits().collect(Collectors.toList()))
                .iterator();

        final List<Instant> points = rangeSplit(from1, to1).toList();
        Commit cCommitPrev = commitsAll.next();
        Commit cCommitAfter = commitsAll.next();

        Set<Commit> commits = new HashSet<>();

        for (Instant cPoint : points) {
            // move till point
            // find closest commits

            long distPrev = getMilliDistance(cCommitPrev.getTimestampInstant(), cPoint);
            long distAfter = getMilliDistance(cCommitAfter.getTimestampInstant(), cPoint);

            while (distPrev > distAfter && commitsAll.hasNext()) {
                // move window
                cCommitPrev = cCommitAfter;
                cCommitAfter = commitsAll.next();

                distPrev = getMilliDistance(cCommitPrev.getTimestampInstant(), cPoint);
                distAfter = getMilliDistance(cCommitAfter.getTimestampInstant(), cPoint);
            }
            // distPrev is best choose

            final Commit bestHit = distPrev < distAfter ? cCommitPrev : cCommitAfter;
            if (commits.add(bestHit)) {
                foundPoints.add(bestHit);

            }
        }

        return foundPoints.stream();
    }

    static long getMilliDelta(Instant start, Instant finish) {
        return finish.toEpochMilli() - start.toEpochMilli();
    }

    private static long getMilliDistance(Instant a, Instant b) {
        return Math.abs(getMilliDelta(a, b));
    }

    public static Stream<Instant> rangeSplit(Instant from, Instant to) {
        final long milliDelta = getMilliDelta(from, to);
        final int TIME_PIECES = 10;
        long step = milliDelta / TIME_PIECES;

        return Stream.iterate(from, (i) -> i.plusMillis(step)).limit(TIME_PIECES + 1);
    }
}
