/*
 * Decompiled with CFR 0.152.
 */
package io.github.andreyzebin.gitSql.config;

import io.github.andreyzebin.gitSql.config.ConfigHistory;
import io.github.andreyzebin.gitSql.config.ConfigTree;
import io.github.andreyzebin.gitSql.git.GitAPI;
import io.github.zebin.javabash.sandbox.PosixPath;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ConfigVersions
implements ConfigHistory,
AutoCloseable {
    public static final String IO_GITHUB_VEZUVIO = "io.github.vezuvio";
    public static final long DEFAULT_LOCK_TIMEOUT_SEC = 3600L;
    private final GitAPI vc;
    private final ConfigTree ct;

    public ConfigVersions(GitAPI vc, ConfigTree ct) {
        this.vc = vc;
        this.ct = ct;
    }

    public boolean pull() {
        this.vc.pull();
        return true;
    }

    public GitAPI getGitAPI() {
        return this.vc;
    }

    @Override
    public String getEffectiveProperty(String hash, PosixPath leaf, String key) {
        return this.getHistorical(hash, () -> this.ct.getEffectiveProperty(leaf, key));
    }

    @Override
    public Set<Map.Entry<PosixPath, String>> getExplodedPropertyKeys(String hash) {
        return this.ct.getLeafs().flatMap(this::flattenEffectiveProperties).collect(Collectors.toSet());
    }

    private Stream<Map.Entry<PosixPath, String>> flattenEffectiveProperties(PosixPath leaf) {
        return this.getEffectivePropertyKeys(leaf).stream().map(k -> new AbstractMap.SimpleEntry<PosixPath, String>(leaf, (String)k));
    }

    public Optional<String> setProperty(PosixPath leaf, String key, String value) {
        return this.ct.setProperty(leaf, key, value);
    }

    public Optional<String> deleteProperty(PosixPath leaf, String key) {
        return this.ct.deleteProperty(leaf, key);
    }

    public String getEffectiveProperty(PosixPath leaf, String key) {
        return this.ct.getEffectiveProperty(leaf, key);
    }

    public Set<String> getEffectivePropertyKeys(PosixPath leaf) {
        return this.ct.getEffectivePropertyKeys(leaf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T getHistorical(String hash, Supplier<T> exec) {
        String branch = this.vc.getBranch().get();
        try {
            this.vc.seek(hash);
            T t = exec.get();
            return t;
        }
        finally {
            this.vc.reset();
            this.vc.setBranch(branch);
        }
    }

    @Override
    public Set<String> getEffectivePropertyKeys(String hash, PosixPath leaf) {
        return this.getHistorical(hash, () -> this.ct.getEffectivePropertyKeys(leaf));
    }

    public Stream<PosixPath> getLeafs() {
        return this.ct.getLeafs();
    }

    @Override
    public Stream<ConfigHistory.PropertiesVersion> listVersions() {
        return this.vc.listCommits().map(c -> ConfigHistory.PropertiesVersion.builder().versionHash(c.getHash()).createdEpochSec(ConfigVersions.toEpochSeconds(c.getTimestamp())).build());
    }

    public static long toEpochSeconds(String timestamp) {
        return Instant.from(DateTimeFormatter.ISO_DATE_TIME.parse(timestamp)).toEpochMilli() / 1000L;
    }

    public static long getNowEpochSec() {
        return Instant.now().getEpochSecond();
    }

    public void commit() {
        this.vc.commit();
    }

    public void push() {
        this.vc.push();
    }

    @Override
    public void close() throws Exception {
    }

    public static class BranchState {
        public String hash;
        public String status;
        public String executorId;

        public static BranchStateBuilder builder() {
            return new BranchStateBuilder();
        }

        public BranchState(String hash, String status, String executorId) {
            this.hash = hash;
            this.status = status;
            this.executorId = executorId;
        }

        public BranchState() {
        }

        public String getHash() {
            return this.hash;
        }

        public String getStatus() {
            return this.status;
        }

        public String getExecutorId() {
            return this.executorId;
        }

        public void setHash(String hash) {
            this.hash = hash;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public void setExecutorId(String executorId) {
            this.executorId = executorId;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BranchState)) {
                return false;
            }
            BranchState other = (BranchState)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$hash = this.getHash();
            String other$hash = other.getHash();
            if (this$hash == null ? other$hash != null : !this$hash.equals(other$hash)) {
                return false;
            }
            String this$status = this.getStatus();
            String other$status = other.getStatus();
            if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
                return false;
            }
            String this$executorId = this.getExecutorId();
            String other$executorId = other.getExecutorId();
            return !(this$executorId == null ? other$executorId != null : !this$executorId.equals(other$executorId));
        }

        protected boolean canEqual(Object other) {
            return other instanceof BranchState;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $hash = this.getHash();
            result = result * 59 + ($hash == null ? 43 : $hash.hashCode());
            String $status = this.getStatus();
            result = result * 59 + ($status == null ? 43 : $status.hashCode());
            String $executorId = this.getExecutorId();
            result = result * 59 + ($executorId == null ? 43 : $executorId.hashCode());
            return result;
        }

        public String toString() {
            return "ConfigVersions.BranchState(hash=" + this.getHash() + ", status=" + this.getStatus() + ", executorId=" + this.getExecutorId() + ")";
        }

        public static class BranchStateBuilder {
            private String hash;
            private String status;
            private String executorId;

            BranchStateBuilder() {
            }

            public BranchStateBuilder hash(String hash) {
                this.hash = hash;
                return this;
            }

            public BranchStateBuilder status(String status) {
                this.status = status;
                return this;
            }

            public BranchStateBuilder executorId(String executorId) {
                this.executorId = executorId;
                return this;
            }

            public BranchState build() {
                return new BranchState(this.hash, this.status, this.executorId);
            }

            public String toString() {
                return "ConfigVersions.BranchState.BranchStateBuilder(hash=" + this.hash + ", status=" + this.status + ", executorId=" + this.executorId + ")";
            }
        }
    }
}

