/*
 * Decompiled with CFR 0.152.
 */
package io.github.andreyzebin.gitSql.git;

import io.github.andreyzebin.gitSql.git.BranchHead;
import io.github.andreyzebin.gitSql.git.Change;
import io.github.andreyzebin.gitSql.git.Commit;
import io.github.andreyzebin.gitSql.git.GitAPI;
import io.github.andreyzebin.gitSql.git.GitBindings;
import io.github.andreyzebin.gitSql.git.GitDirectory;
import io.github.andreyzebin.gitSql.git.Versions;
import io.github.zebin.javabash.process.TextTerminal;
import io.github.zebin.javabash.sandbox.BashUtils;
import io.github.zebin.javabash.sandbox.DirectoryTree;
import io.github.zebin.javabash.sandbox.FileManager;
import io.github.zebin.javabash.sandbox.WorkingDirectory;
import java.nio.file.Path;
import java.time.Instant;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractClient
implements GitDirectory,
GitAPI {
    private static final Logger log = LoggerFactory.getLogger(AbstractClient.class);
    protected final TextTerminal term;
    private Optional<String> origin = null;
    protected final StringBuffer stage = new StringBuffer();

    protected AbstractClient(TextTerminal term) {
        this.term = term;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Versions seek(String commit) {
        String pwd = this.term.eval("pwd");
        try {
            this.term.eval("cd " + BashUtils.encode((Path)this.getRoot()));
            GitBindings.checkout(commit, this.term);
            AbstractClient abstractClient = this;
            return abstractClient;
        }
        finally {
            this.term.eval("cd " + pwd);
        }
    }

    @Override
    public void reset() {
        String pwd = this.term.eval("pwd");
        try {
            this.term.eval("cd " + BashUtils.encode((Path)this.getRoot()));
            GitBindings.resetHard(this.term);
        }
        finally {
            this.term.eval("cd " + pwd);
        }
    }

    public Stream<Commit> listCommits() {
        String pwd = this.term.eval("pwd");
        try {
            this.term.eval("cd " + BashUtils.encode((Path)this.getRoot()));
            Stream<Commit> stream = GitBindings.commitsList(this.term);
            return stream;
        }
        finally {
            this.term.eval("cd " + pwd);
        }
    }

    @Override
    public Stream<BranchHead> listBranches() {
        String pwd = this.term.eval("pwd");
        try {
            this.term.eval("cd " + BashUtils.encode((Path)this.getRoot()));
            Stream<BranchHead> stream = GitBindings.getBranches(this.term);
            return stream;
        }
        finally {
            this.term.eval("cd " + pwd);
        }
    }

    @Override
    public boolean contains(String hash) {
        HashSet commits = new HashSet();
        this.listCommits().forEach(co -> {
            commits.add(co.getHash());
            commits.addAll(co.getParents());
        });
        return commits.contains(hash);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Stream<? extends Change> getChanges(String hashFrom) {
        String pwd = this.term.eval("pwd");
        try {
            this.term.eval("cd " + BashUtils.encode((Path)this.getRoot()));
            Stream<Change> stream = GitBindings.filesChangedQuery("", GitBindings.sinceHash(hashFrom), this.term);
            return stream;
        }
        finally {
            this.term.eval("cd " + pwd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Stream<? extends Change> getChanges(String hashFrom, String hashTo) {
        String pwd = this.term.eval("pwd");
        try {
            this.term.eval("cd " + BashUtils.encode((Path)this.getLocation().toPath()));
            Stream<Change> stream = GitBindings.filesChangedQuery("", GitBindings.periodHash(hashFrom, hashTo), this.term);
            return stream;
        }
        finally {
            this.term.eval("cd " + pwd);
        }
    }

    @Override
    public Instant getTimestamp() {
        String pwd = this.term.eval("pwd");
        try {
            this.term.eval("cd " + BashUtils.encode((Path)this.getRoot()));
            Instant instant = GitBindings.commitsList(this.term).findFirst().get().getTimestampInstant();
            return instant;
        }
        finally {
            this.term.eval("cd " + pwd);
        }
    }

    @Override
    public void pull() {
        String pwd = this.term.eval("pwd");
        try {
            this.term.eval("cd " + BashUtils.encode((Path)this.getLocation().toPath()));
            GitBindings.pull(this.term);
        }
        finally {
            this.term.eval("cd " + pwd);
        }
    }

    @Override
    public void push() {
        String pwd = this.term.eval("pwd");
        try {
            this.term.eval("cd " + BashUtils.encode((Path)this.getLocation().toPath()));
            GitBindings.push(this.term);
        }
        finally {
            this.term.eval("cd " + pwd);
        }
    }

    @Override
    public void setOrigin(String origin) {
        throw new RuntimeException("Unimplemented!");
    }

    @Override
    public Optional<String> getOrigin() {
        String pwd = this.term.eval("pwd");
        try {
            if (this.origin == null) {
                this.term.eval("cd " + BashUtils.encode((Path)this.getRoot()));
                this.origin = GitBindings.getOrigin(this.term);
            }
            Optional<String> optional = this.origin;
            return optional;
        }
        finally {
            this.term.eval("cd " + pwd);
        }
    }

    @Override
    public void fetch() {
        String pwd = this.term.eval("pwd");
        try {
            this.term.eval("cd " + BashUtils.encode((Path)this.getRoot()));
            this.term.eval(String.format("git fetch", new Object[0]));
        }
        finally {
            this.term.eval("cd " + pwd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUpstream(String localBranch, String upstream) {
        String pwd = this.term.eval("pwd");
        try {
            this.term.eval("cd " + BashUtils.encode((Path)this.getRoot()));
            this.term.eval(String.format("git branch -u  %s %s ", upstream, localBranch));
        }
        finally {
            this.term.eval("cd " + pwd);
        }
    }

    @Override
    public Optional<String> getUpstream(String local) {
        throw new RuntimeException("Unimplemented!");
    }

    @Override
    public Optional<String> getBranch() {
        String pwd = this.term.eval("pwd");
        try {
            this.term.eval("cd " + BashUtils.encode((Path)this.getRoot()));
            Optional<String> optional = GitBindings.getBranch(this.term);
            return optional;
        }
        finally {
            this.term.eval("cd " + pwd);
        }
    }

    @Override
    public void setBranch(String branchName) {
        String pwd = this.term.eval("pwd");
        try {
            this.term.eval("cd " + BashUtils.encode((Path)this.getRoot()));
            this.term.eval(String.format("git checkout %s ", branchName));
        }
        finally {
            this.term.eval("cd " + pwd);
        }
    }

    @Override
    public void commit() {
        if (!this.stage.toString().isBlank()) {
            BashUtils.lockDir((TextTerminal)this.term, () -> {
                this.term.eval("cd " + BashUtils.encode((Path)this.getRoot()));
                Arrays.stream(this.stage.toString().split(System.lineSeparator())).forEach(cFile -> GitBindings.add(this.term, Path.of(cFile, new String[0])));
                if (GitBindings.hasStatus(this.term)) {
                    GitBindings.commit(this.term);
                } else {
                    log.debug("Status has no changes, skip commit.");
                }
                return 0;
            });
        }
        this.stage.setLength(0);
    }

    public DirectoryTree getDirectory() {
        return new WorkingDirectory(new FileManager(this.term), this.getLocation(), f -> BashUtils.append((StringBuffer)this.stage, (String)f.getPath().toString()));
    }
}

