/*
 * Decompiled with CFR 0.152.
 */
package io.github.andreyzebin.gitSql.git;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.List;

public class Commit {
    private List<String> parents;
    private String hash;
    private String timestamp;
    private String unixTimestamp;
    private String committerEmail;
    private String committerName;
    private String authorEmail;
    private String authorName;

    @JsonIgnore
    public Instant getTimestampInstant() {
        return Instant.from(DateTimeFormatter.ISO_INSTANT.parse(this.timestamp));
    }

    public static CommitBuilder builder() {
        return new CommitBuilder();
    }

    public List<String> getParents() {
        return this.parents;
    }

    public String getHash() {
        return this.hash;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public String getUnixTimestamp() {
        return this.unixTimestamp;
    }

    public String getCommitterEmail() {
        return this.committerEmail;
    }

    public String getCommitterName() {
        return this.committerName;
    }

    public String getAuthorEmail() {
        return this.authorEmail;
    }

    public String getAuthorName() {
        return this.authorName;
    }

    public void setParents(List<String> parents) {
        this.parents = parents;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    public void setTimestamp(String timestamp) {
        this.timestamp = timestamp;
    }

    public void setUnixTimestamp(String unixTimestamp) {
        this.unixTimestamp = unixTimestamp;
    }

    public void setCommitterEmail(String committerEmail) {
        this.committerEmail = committerEmail;
    }

    public void setCommitterName(String committerName) {
        this.committerName = committerName;
    }

    public void setAuthorEmail(String authorEmail) {
        this.authorEmail = authorEmail;
    }

    public void setAuthorName(String authorName) {
        this.authorName = authorName;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Commit)) {
            return false;
        }
        Commit other = (Commit)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<String> this$parents = this.getParents();
        List<String> other$parents = other.getParents();
        if (this$parents == null ? other$parents != null : !((Object)this$parents).equals(other$parents)) {
            return false;
        }
        String this$hash = this.getHash();
        String other$hash = other.getHash();
        if (this$hash == null ? other$hash != null : !this$hash.equals(other$hash)) {
            return false;
        }
        String this$timestamp = this.getTimestamp();
        String other$timestamp = other.getTimestamp();
        if (this$timestamp == null ? other$timestamp != null : !this$timestamp.equals(other$timestamp)) {
            return false;
        }
        String this$unixTimestamp = this.getUnixTimestamp();
        String other$unixTimestamp = other.getUnixTimestamp();
        if (this$unixTimestamp == null ? other$unixTimestamp != null : !this$unixTimestamp.equals(other$unixTimestamp)) {
            return false;
        }
        String this$committerEmail = this.getCommitterEmail();
        String other$committerEmail = other.getCommitterEmail();
        if (this$committerEmail == null ? other$committerEmail != null : !this$committerEmail.equals(other$committerEmail)) {
            return false;
        }
        String this$committerName = this.getCommitterName();
        String other$committerName = other.getCommitterName();
        if (this$committerName == null ? other$committerName != null : !this$committerName.equals(other$committerName)) {
            return false;
        }
        String this$authorEmail = this.getAuthorEmail();
        String other$authorEmail = other.getAuthorEmail();
        if (this$authorEmail == null ? other$authorEmail != null : !this$authorEmail.equals(other$authorEmail)) {
            return false;
        }
        String this$authorName = this.getAuthorName();
        String other$authorName = other.getAuthorName();
        return !(this$authorName == null ? other$authorName != null : !this$authorName.equals(other$authorName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Commit;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<String> $parents = this.getParents();
        result = result * 59 + ($parents == null ? 43 : ((Object)$parents).hashCode());
        String $hash = this.getHash();
        result = result * 59 + ($hash == null ? 43 : $hash.hashCode());
        String $timestamp = this.getTimestamp();
        result = result * 59 + ($timestamp == null ? 43 : $timestamp.hashCode());
        String $unixTimestamp = this.getUnixTimestamp();
        result = result * 59 + ($unixTimestamp == null ? 43 : $unixTimestamp.hashCode());
        String $committerEmail = this.getCommitterEmail();
        result = result * 59 + ($committerEmail == null ? 43 : $committerEmail.hashCode());
        String $committerName = this.getCommitterName();
        result = result * 59 + ($committerName == null ? 43 : $committerName.hashCode());
        String $authorEmail = this.getAuthorEmail();
        result = result * 59 + ($authorEmail == null ? 43 : $authorEmail.hashCode());
        String $authorName = this.getAuthorName();
        result = result * 59 + ($authorName == null ? 43 : $authorName.hashCode());
        return result;
    }

    public String toString() {
        return "Commit(parents=" + String.valueOf(this.getParents()) + ", hash=" + this.getHash() + ", timestamp=" + this.getTimestamp() + ", unixTimestamp=" + this.getUnixTimestamp() + ", committerEmail=" + this.getCommitterEmail() + ", committerName=" + this.getCommitterName() + ", authorEmail=" + this.getAuthorEmail() + ", authorName=" + this.getAuthorName() + ")";
    }

    public Commit(List<String> parents, String hash, String timestamp, String unixTimestamp, String committerEmail, String committerName, String authorEmail, String authorName) {
        this.parents = parents;
        this.hash = hash;
        this.timestamp = timestamp;
        this.unixTimestamp = unixTimestamp;
        this.committerEmail = committerEmail;
        this.committerName = committerName;
        this.authorEmail = authorEmail;
        this.authorName = authorName;
    }

    public Commit() {
    }

    public static class CommitBuilder {
        private List<String> parents;
        private String hash;
        private String timestamp;
        private String unixTimestamp;
        private String committerEmail;
        private String committerName;
        private String authorEmail;
        private String authorName;

        CommitBuilder() {
        }

        public CommitBuilder parents(List<String> parents) {
            this.parents = parents;
            return this;
        }

        public CommitBuilder hash(String hash) {
            this.hash = hash;
            return this;
        }

        public CommitBuilder timestamp(String timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public CommitBuilder unixTimestamp(String unixTimestamp) {
            this.unixTimestamp = unixTimestamp;
            return this;
        }

        public CommitBuilder committerEmail(String committerEmail) {
            this.committerEmail = committerEmail;
            return this;
        }

        public CommitBuilder committerName(String committerName) {
            this.committerName = committerName;
            return this;
        }

        public CommitBuilder authorEmail(String authorEmail) {
            this.authorEmail = authorEmail;
            return this;
        }

        public CommitBuilder authorName(String authorName) {
            this.authorName = authorName;
            return this;
        }

        public Commit build() {
            return new Commit(this.parents, this.hash, this.timestamp, this.unixTimestamp, this.committerEmail, this.committerName, this.authorEmail, this.authorName);
        }

        public String toString() {
            return "Commit.CommitBuilder(parents=" + String.valueOf(this.parents) + ", hash=" + this.hash + ", timestamp=" + this.timestamp + ", unixTimestamp=" + this.unixTimestamp + ", committerEmail=" + this.committerEmail + ", committerName=" + this.committerName + ", authorEmail=" + this.authorEmail + ", authorName=" + this.authorName + ")";
        }
    }
}

