/*
 * Decompiled with CFR 0.152.
 */
package io.github.andreyzebin.gitSql.git;

import io.github.andreyzebin.gitSql.git.AbstractClient;
import io.github.andreyzebin.gitSql.git.GitBindings;
import io.github.zebin.javabash.process.TextTerminal;
import io.github.zebin.javabash.sandbox.BashUtils;
import java.nio.file.Path;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalSource
extends AbstractClient {
    private static final Logger log = LoggerFactory.getLogger(LocalSource.class);
    private final Path root;
    private final TextTerminal term;

    public LocalSource(Path root, TextTerminal term) {
        super(term);
        this.term = term;
        this.root = root.toAbsolutePath();
    }

    @Override
    public Path getRoot() {
        return this.root;
    }

    @Override
    public void pull() {
        String pwd = this.term.eval("pwd");
        try {
            this.term.eval("cd " + BashUtils.encode((Path)this.getRoot()));
            GitBindings.pull(this.term);
        }
        finally {
            this.term.eval("cd " + pwd);
        }
    }

    @Override
    public void close() {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LocalSource that = (LocalSource)o;
        return Objects.equals(this.root, that.root);
    }

    public int hashCode() {
        return Objects.hash(this.root);
    }
}

