/*
 * Decompiled with CFR 0.152.
 */
package io.github.andreyzebin.gitSql.cache;

import io.github.andreyzebin.gitSql.FileSystemUtils;
import io.github.andreyzebin.gitSql.cache.FileManagerCacheProxy;
import io.github.andreyzebin.gitSql.cache.GitEventListener;
import io.github.zebin.javabash.sandbox.DirectoryTree;
import io.github.zebin.javabash.sandbox.PosixPath;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.lang.invoke.LambdaMetafactory;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectoryTreeCacheProxy
implements DirectoryTree,
GitEventListener {
    private static final Logger log = LoggerFactory.getLogger(DirectoryTreeCacheProxy.class);
    private final DirectoryTree dt;
    private final AtomicReference<String> cacheControl;
    private final Map<String, FileManagerCacheProxy.FileManagerCache> caches;
    private final Map<String, FileManagerCacheProxy.FileReadCache> readCaches;
    private final Map<String, FileManagerCacheProxy.LsCache> lsCache;

    public DirectoryTreeCacheProxy(DirectoryTree dt, AtomicReference<String> cacheControl, Map<String, FileManagerCacheProxy.FileManagerCache> caches, Map<String, FileManagerCacheProxy.FileReadCache> readCaches, Map<String, FileManagerCacheProxy.LsCache> lsCache) {
        this.dt = dt;
        this.cacheControl = cacheControl;
        this.caches = caches;
        this.readCaches = readCaches;
        this.lsCache = lsCache;
    }

    public static DirectoryTreeCacheProxy cachedProxy(DirectoryTree delegate, AtomicReference<String> cacheControl) {
        HashMap<String, FileManagerCacheProxy.FileManagerCache> fmCache = new HashMap<String, FileManagerCacheProxy.FileManagerCache>();
        HashMap<String, FileManagerCacheProxy.FileReadCache> readCaches = new HashMap<String, FileManagerCacheProxy.FileReadCache>();
        HashMap<String, FileManagerCacheProxy.LsCache> lsCache = new HashMap<String, FileManagerCacheProxy.LsCache>();
        return new DirectoryTreeCacheProxy(delegate, cacheControl, fmCache, readCaches, lsCache);
    }

    @Override
    public void call(String event) {
        if (event.equals("clear")) {
            this.readCaches.remove(this.cacheControl.get());
            this.caches.remove(this.cacheControl.get());
            this.lsCache.remove(this.cacheControl.get());
        }
    }

    private void dropDir(PosixPath d) {
        this.getDirsCache().remove(d);
    }

    private void dropFile(PosixPath d) {
        this.getReadCache().remove(d);
        this.getFilesCache().remove(d);
    }

    private Map<PosixPath, Boolean> getDirsCache() {
        return this.getCache().dirs;
    }

    private Map<PosixPath, Boolean> getFilesCache() {
        return this.getCache().files;
    }

    private FileManagerCacheProxy.FileManagerCache getCache() {
        if (this.cacheControl.get() == null) {
            return new FileManagerCacheProxy.FileManagerCache();
        }
        return this.caches.computeIfAbsent(this.cacheControl.get(), h -> new FileManagerCacheProxy.FileManagerCache());
    }

    private Map<PosixPath, String> getReadCache() {
        if (this.cacheControl.get() == null) {
            return new FileManagerCacheProxy.FileReadCache().files;
        }
        return this.readCaches.computeIfAbsent((String)this.cacheControl.get(), (Function<String, FileManagerCacheProxy.FileReadCache>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$getReadCache$1(java.lang.String ), (Ljava/lang/String;)Lio/github/andreyzebin/gitSql/cache/FileManagerCacheProxy$FileReadCache;)()).files;
    }

    private Map<PosixPath, List<PosixPath>> getLsCache() {
        if (this.cacheControl.get() == null) {
            return new FileManagerCacheProxy.LsCache().files;
        }
        return this.lsCache.computeIfAbsent((String)this.cacheControl.get(), (Function<String, FileManagerCacheProxy.LsCache>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$getLsCache$2(java.lang.String ), (Ljava/lang/String;)Lio/github/andreyzebin/gitSql/cache/FileManagerCacheProxy$LsCache;)()).files;
    }

    public Writer put(PosixPath posixPath) {
        posixPath.streamDescending().forEach(this::dropDir);
        this.dropFile(posixPath);
        return this.dt.put(posixPath);
    }

    public boolean delete(PosixPath posixPath) {
        this.getFilesCache().keySet().stream().filter(kk -> kk.startsWith(posixPath)).forEach(kk -> this.getFilesCache().remove(kk));
        this.getReadCache().keySet().stream().filter(kk -> kk.startsWith(posixPath)).forEach(kk -> this.getReadCache().remove(kk));
        this.getDirsCache().keySet().stream().filter(kk -> kk.startsWith(posixPath)).forEach(kk -> this.getDirsCache().remove(kk));
        return false;
    }

    public Writer patch(PosixPath posixPath) {
        posixPath.streamDescending().forEach(this::dropDir);
        this.dropFile(posixPath);
        return this.dt.patch(posixPath);
    }

    public Reader get(PosixPath posixPath) {
        return new StringReader(this.getReadCache().computeIfAbsent(posixPath, p -> FileSystemUtils.loadFile(this.dt.get(posixPath))));
    }

    public boolean exists(PosixPath posixPath) {
        Boolean dirExists = this.getDirsCache().computeIfAbsent(posixPath, d -> this.dt.isDir(posixPath));
        Boolean fileExists = this.getFilesCache().computeIfAbsent(posixPath, f -> this.dt.exists(posixPath) && dirExists == false);
        return fileExists != false || dirExists != false;
    }

    public boolean isDir(PosixPath posixPath) {
        return this.getDirsCache().computeIfAbsent(posixPath, d -> this.dt.isDir(posixPath));
    }

    public Stream<PosixPath> list(PosixPath posixPath) {
        return this.getLsCache().computeIfAbsent(posixPath, p -> this.dt.list(posixPath).toList()).stream();
    }

    public void traverse(PosixPath start, Function<PosixPath, Boolean> sayEnter) {
        this.dt.traverse(start, sayEnter);
    }

    public <T> T setupDir(Supplier<T> result) {
        return (T)this.dt.setupDir(result);
    }

    private static /* synthetic */ FileManagerCacheProxy.LsCache lambda$getLsCache$2(String h) {
        return new FileManagerCacheProxy.LsCache();
    }

    private static /* synthetic */ FileManagerCacheProxy.FileReadCache lambda$getReadCache$1(String h) {
        return new FileManagerCacheProxy.FileReadCache();
    }
}

