/*
 * Decompiled with CFR 0.152.
 */
package io.github.andreyzebin.gitSql.sql;

import io.github.andreyzebin.gitSql.git.VersionedFiles;
import io.github.andreyzebin.gitSql.sql.PersistedIndex;
import io.github.andreyzebin.gitSql.sql.SqlBrush;
import io.github.andreyzebin.gitSql.sql.SqlUtils;
import java.nio.file.Path;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommitsIndex
extends PersistedIndex {
    private static final Logger log = LoggerFactory.getLogger(CommitsIndex.class);
    private final VersionedFiles git;

    public CommitsIndex(VersionedFiles git, Path storeDir) {
        super(storeDir);
        this.git = git;
    }

    @Override
    protected void createSchema() throws SQLException {
        try (Statement dml = this.getConnection().createStatement();){
            String sql = "CREATE TABLE IF NOT EXISTS commits\n(\n    ID INT auto_increment,\n    hash VARCHAR(256) NOT NULL,\n    timestamp timestamp NOT NULL,\n    UNIQUE NULLS ALL DISTINCT (hash)\n);";
            log.debug(CommitsIndex.renderSqlLog("CREATE TABLE IF NOT EXISTS commits\n(\n    ID INT auto_increment,\n    hash VARCHAR(256) NOT NULL,\n    timestamp timestamp NOT NULL,\n    UNIQUE NULLS ALL DISTINCT (hash)\n);"));
            dml.execute("CREATE TABLE IF NOT EXISTS commits\n(\n    ID INT auto_increment,\n    hash VARCHAR(256) NOT NULL,\n    timestamp timestamp NOT NULL,\n    UNIQUE NULLS ALL DISTINCT (hash)\n);");
        }
        super.createSchema();
    }

    public static String renderSqlLog(String sql) {
        return System.lineSeparator() + "---" + System.lineSeparator() + sql.lines().map(SqlBrush::sqlRender).collect(Collectors.joining(System.lineSeparator())) + System.lineSeparator() + "---";
    }

    @Override
    protected void reindex() {
        try {
            this.git.getSource().listCommits().forEach(cF -> SqlUtils.merge(this.getConnection(), "commits", "hash", "timestamp", cF.getHash(), cF.getTimestamp()));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

