/*
 * Decompiled with CFR 0.152.
 */
package sk.antons.iban;

import java.util.ArrayList;
import java.util.List;
import sk.antons.iban.IbanSubstringCheck;
import sk.antons.iban.IbanSubstringResolver;

public class IbanConfig {
    String id;
    int length;
    String pattern;
    List<IbanSubstringCheck> substringChecks;
    private int cachedResolversSize = 0;
    private char[] cachedResolverChars;
    private IbanSubstringResolver[] cachedResolvers;

    protected IbanConfig(String countryCode) {
        this.id = countryCode;
    }

    public static IbanConfig instance(String countryCode) {
        return new IbanConfig(countryCode);
    }

    public String id() {
        return this.id;
    }

    public int length() {
        return this.length;
    }

    public IbanConfig length(int value) {
        this.length = value;
        return this;
    }

    public String pattern() {
        return this.pattern;
    }

    public IbanConfig pattern(String value) {
        this.pattern = value;
        return this;
    }

    public List<IbanSubstringCheck> substringChecks() {
        return this.substringChecks;
    }

    public IbanConfig substringCheck(IbanSubstringCheck value) {
        if (value == null) {
            return this;
        }
        if (this.substringChecks == null) {
            this.substringChecks = new ArrayList<IbanSubstringCheck>();
        }
        this.substringChecks.add(value);
        return this;
    }

    public IbanConfig numeric(int startPos, int endPos) {
        return this.substringCheck(IbanSubstringCheck.numeric(startPos, endPos));
    }

    public IbanConfig capitals(int startPos, int endPos) {
        return this.substringCheck(IbanSubstringCheck.capitals(startPos, endPos));
    }

    public IbanConfig letters(int startPos, int endPos) {
        return this.substringCheck(IbanSubstringCheck.letters(startPos, endPos));
    }

    protected synchronized IbanSubstringResolver resolver(char c) {
        if (this.cachedResolversSize == 0) {
            this.cachedResolverChars = new char[30];
            this.cachedResolvers = new IbanSubstringResolver[30];
        }
        if (this.cachedResolversSize == this.cachedResolvers.length) {
            char[] newcachedResolverChars = new char[this.cachedResolversSize + 30];
            IbanSubstringResolver[] newcachedResolvers = new IbanSubstringResolver[this.cachedResolversSize + 30];
            System.arraycopy(this.cachedResolverChars, 0, newcachedResolverChars, 0, this.cachedResolversSize);
            System.arraycopy(this.cachedResolvers, 0, newcachedResolvers, 0, this.cachedResolversSize);
            this.cachedResolverChars = newcachedResolverChars;
            this.cachedResolvers = newcachedResolvers;
        }
        int pos = -1;
        for (int i = 0; i < this.cachedResolversSize; ++i) {
            if (this.cachedResolverChars[i] != c) continue;
            return this.cachedResolvers[i];
        }
        IbanSubstringResolver r = this.resolveResolver(c);
        this.cachedResolverChars[this.cachedResolversSize] = c;
        this.cachedResolvers[this.cachedResolversSize] = r;
        ++this.cachedResolversSize;
        return r;
    }

    private IbanSubstringResolver resolveResolver(char c) {
        int startPos = -1;
        int endPos = -1;
        int len = this.pattern.length();
        for (int i = 0; i < len; ++i) {
            char cc = this.pattern.charAt(i);
            if (cc == c) {
                if (startPos == -1) {
                    startPos = i;
                    continue;
                }
                if (endPos == -1) continue;
                return IbanSubstringResolver.Pattern.instance(c, this.pattern);
            }
            if (startPos == -1 || endPos != -1) continue;
            endPos = i;
        }
        if (startPos != -1 && endPos == -1) {
            endPos = len;
        }
        if (startPos != -1) {
            return IbanSubstringResolver.Substring.instance(startPos, endPos);
        }
        return IbanSubstringResolver.None.instance();
    }

    protected boolean formatCheck(String iban) {
        if (this.substringChecks == null) {
            return true;
        }
        for (IbanSubstringCheck substringCheck : this.substringChecks) {
            if (substringCheck.validate(iban)) continue;
            return false;
        }
        return true;
    }

    protected String format() {
        if (this.substringChecks == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (IbanSubstringCheck substringCheck : this.substringChecks) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(substringCheck);
        }
        return sb.toString();
    }
}

