/*
 * Decompiled with CFR 0.152.
 */
package sk.antons.iban;

public interface IbanSubstringResolver {
    public String resolve(String var1);

    public static class Pattern
    implements IbanSubstringResolver {
        char c;
        String pattern;

        @Override
        public String resolve(String iban) {
            StringBuilder sb = new StringBuilder();
            int len = this.pattern.length();
            for (int i = 0; i < len; ++i) {
                char cc = this.pattern.charAt(i);
                if (this.c != cc) continue;
                char ccc = iban.charAt(i);
                sb.append(ccc);
            }
            return sb.length() == 0 ? null : sb.toString();
        }

        public Pattern(char c, String pattern) {
            this.c = c;
            this.pattern = pattern;
        }

        public static Pattern instance(char c, String pattern) {
            return new Pattern(c, pattern);
        }

        public String toString() {
            return "Pattern{c=" + this.c + ", pattern=" + this.pattern + '}';
        }
    }

    public static class Substring
    implements IbanSubstringResolver {
        int startPos;
        int endPos;

        @Override
        public String resolve(String iban) {
            return iban.substring(this.startPos, this.endPos);
        }

        public Substring(int startPos, int endPos) {
            this.startPos = startPos;
            this.endPos = endPos;
        }

        public static Substring instance(int startPos, int endPos) {
            return new Substring(startPos, endPos);
        }

        public String toString() {
            return "Substring{startPos=" + this.startPos + ", endPos=" + this.endPos + '}';
        }
    }

    public static class None
    implements IbanSubstringResolver {
        @Override
        public String resolve(String iban) {
            return null;
        }

        public static None instance() {
            return new None();
        }

        public String toString() {
            return "None{}";
        }
    }
}

