/*
 * Decompiled with CFR 0.152.
 */
package sk.antons.sbsplitter;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;

public class SBEnhancer {
    private MavenProject project;
    private String filename;
    private String destDir;
    private String appFolder = "app/";
    private String classesFolder = "classes/";
    private String libsFolder = "libs/";
    private String snapshotsFolder = "snapshots/";
    private String loaderFolder = "loader/";
    private String metaFolder = "meta/";

    public static SBEnhancer instance() {
        return new SBEnhancer();
    }

    public MavenProject project() {
        return this.project;
    }

    public SBEnhancer project(MavenProject value) {
        this.project = value;
        return this;
    }

    public String filename() {
        return this.filename;
    }

    public SBEnhancer filename(String value) {
        this.filename = value;
        return this;
    }

    public String destDir() {
        return this.destDir;
    }

    public SBEnhancer destDir(String value) {
        this.destDir = value;
        return this;
    }

    public String appFolder() {
        return this.appFolder;
    }

    public SBEnhancer appFolder(String value) {
        this.appFolder = value;
        return this;
    }

    public String classesFolder() {
        return this.classesFolder;
    }

    public SBEnhancer classesFolder(String value) {
        this.classesFolder = value;
        return this;
    }

    public String libsFolder() {
        return this.libsFolder;
    }

    public SBEnhancer libsFolder(String value) {
        this.libsFolder = value;
        return this;
    }

    public String snapshotsFolder() {
        return this.snapshotsFolder;
    }

    public SBEnhancer snapshotsFolder(String value) {
        this.snapshotsFolder = value;
        return this;
    }

    public String loaderFolder() {
        return this.loaderFolder;
    }

    public SBEnhancer loaderFolder(String value) {
        this.loaderFolder = value;
        return this;
    }

    public String metaFolder() {
        return this.metaFolder;
    }

    public SBEnhancer metaFolder(String value) {
        this.metaFolder = value;
        return this;
    }

    public void enhance(Log log) {
        List<String> cp = this.loadCP();
        this.generateCPScript(cp);
        log.info((CharSequence)"[SB split] classpath script generated");
        this.generateStartScript();
        log.info((CharSequence)"[SB split] dummy start script generated");
        this.generateDockerfile1();
        this.generateDockerfile2();
        log.info((CharSequence)"[SB split] dummy docker file generated");
        this.updateModificationDate(new File(this.destDir + this.appFolder + this.libsFolder), 0L);
        log.info((CharSequence)"[SB split] lib modules freeze modification time");
    }

    private void listFiles(File folder, String prefix, List<String> list) {
        File[] children = folder.listFiles();
        if (children == null) {
            return;
        }
        for (File file : children) {
            String neprefix = file.getName();
            if (prefix != null) {
                neprefix = prefix + "/" + neprefix;
            }
            if (file.isDirectory()) {
                this.listFiles(file, neprefix, list);
                continue;
            }
            list.add(neprefix);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<String> loadCP() {
        ArrayList<String> rv = new ArrayList<String>();
        File f = new File(this.destDir + this.appFolder + this.metaFolder + "/BOOT-INF/classpath.txt");
        if (f.exists()) {
            try {
                String[] data;
                FileInputStream fis = new FileInputStream(f);
                BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)fis, "utf-8"));
                String line = reader.readLine();
                if (line == null) return rv;
                for (String string : data = line.split(":")) {
                    if (string == null || "".equals(string = string.trim())) continue;
                    File ff = new File(string);
                    rv.add(ff.getName());
                }
                return rv;
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
        }
        try {
            List items = this.project.getRuntimeClasspathElements();
            for (String string : items) {
                if (string == null || "".equals(string = string.trim()) || string.endsWith("classes")) continue;
                File ff = new File(string);
                rv.add(ff.getName());
            }
            return rv;
        }
        catch (DependencyResolutionRequiredException dependencyResolutionRequiredException) {
            // empty catch block
        }
        return rv;
    }

    private static String removeSlash(String value) {
        if (value.endsWith("/")) {
            value = value.substring(0, value.length() - 1);
        }
        return value;
    }

    public void generateDockerfile1() {
        String startclass = "Application";
        File meta = new File(this.destDir + this.appFolder + this.metaFolder + "/META-INF/MANIFEST.MF");
        if (meta.exists()) {
            try (FileInputStream fis = new FileInputStream(meta);){
                BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)fis, "utf-8"));
                String line = reader.readLine();
                while (line != null) {
                    if (line.startsWith("Start-Class: ")) {
                        startclass = line.substring(13);
                        break;
                    }
                    line = reader.readLine();
                }
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
        }
        StringBuilder sb = new StringBuilder();
        sb.append("FROM eclipse-temurin:21-jdk-alpine\n");
        sb.append("\n");
        sb.append("COPY ./").append(this.appFolder).append(this.libsFolder).append(" /app/").append(this.libsFolder).append("\n");
        sb.append("COPY ./").append(this.appFolder).append(this.loaderFolder).append(" /app/").append(this.loaderFolder).append("\n");
        sb.append("COPY ./").append(this.appFolder).append(this.snapshotsFolder).append(" /app/").append(this.snapshotsFolder).append("\n");
        sb.append("COPY ./").append(this.appFolder).append(this.metaFolder).append(" /app/").append(this.metaFolder).append("\n");
        sb.append("COPY ./").append(this.appFolder).append(this.classesFolder).append(" /app/").append(this.classesFolder).append("\n");
        sb.append("COPY ./").append(this.appFolder).append("cp.arg").append(" /app/").append("cp.arg").append("\n");
        sb.append("\n");
        sb.append("WORKDIR /app\n");
        sb.append("\n");
        sb.append("ENTRYPOINT [\"java\", \"-Djava.security.egd=file:/dev/./urandom\", \"@cp.arg\", \"").append(startclass).append("\"]\n");
        try {
            File f = new File(this.destDir + "/Dockerfile.template1");
            File p = f.getParentFile();
            if (!p.exists()) {
                p.mkdirs();
            }
            FileOutputStream fos = new FileOutputStream(f);
            fos.write(sb.toString().getBytes("utf-8"));
            fos.flush();
            fos.close();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public void generateDockerfile2() {
        String startclass = "Application";
        File meta = new File(this.destDir + this.appFolder + this.metaFolder + "/META-INF/MANIFEST.MF");
        if (meta.exists()) {
            try (FileInputStream fis = new FileInputStream(meta);){
                BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)fis, "utf-8"));
                String line = reader.readLine();
                while (line != null) {
                    if (line.startsWith("Start-Class: ")) {
                        startclass = line.substring(13);
                        break;
                    }
                    line = reader.readLine();
                }
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
        }
        StringBuilder sb = new StringBuilder();
        sb.append("FROM eclipse-temurin:21-jdk-alpine\n");
        sb.append("\n");
        sb.append("COPY ./").append(this.appFolder).append(this.libsFolder).append(" /app/BOOT-INF/lib/").append("\n");
        sb.append("COPY ./").append(this.appFolder).append(this.loaderFolder).append(" /app/").append("\n");
        sb.append("COPY ./").append(this.appFolder).append(this.snapshotsFolder).append(" /app/BOOT-INF/lib/").append("\n");
        sb.append("COPY ./").append(this.appFolder).append(this.metaFolder).append(" /app/").append("\n");
        sb.append("COPY ./").append(this.appFolder).append(this.classesFolder).append(" /app/BOOT-INF/classes/").append("\n");
        sb.append("\n");
        sb.append("WORKDIR /app\n");
        sb.append("\n");
        sb.append("ENTRYPOINT [\"java\", \"-Djava.security.egd=file:/dev/./urandom\", \"org.springframework.boot.loader.launch.JarLauncher\"]\n");
        try {
            File f = new File(this.destDir + "/Dockerfile");
            File p = f.getParentFile();
            if (!p.exists()) {
                p.mkdirs();
            }
            FileOutputStream fos = new FileOutputStream(f);
            fos.write(sb.toString().getBytes("utf-8"));
            fos.flush();
            fos.close();
            f = new File(this.destDir + "/Dockerfile.template2");
            p = f.getParentFile();
            if (!p.exists()) {
                p.mkdirs();
            }
            fos = new FileOutputStream(f);
            fos.write(sb.toString().getBytes("utf-8"));
            fos.flush();
            fos.close();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public void generateStartScript() {
        StringBuilder sb2 = new StringBuilder();
        String startclass = "Application";
        File meta = new File(this.destDir + this.appFolder + this.metaFolder + "/META-INF/MANIFEST.MF");
        if (meta.exists()) {
            try (FileInputStream fis = new FileInputStream(meta);){
                BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)fis, "utf-8"));
                String line = reader.readLine();
                while (line != null) {
                    if (line.startsWith("Start-Class: ")) {
                        startclass = line.substring(13);
                        break;
                    }
                    line = reader.readLine();
                }
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
        }
        sb2.append("#!/bin/bash\n");
        sb2.append("java @cp.arg ").append(startclass);
        try {
            File f = new File(this.destDir + this.appFolder + "/start.sh");
            File p = f.getParentFile();
            if (!p.exists()) {
                p.mkdirs();
            }
            FileOutputStream fos = new FileOutputStream(f);
            fos.write(sb2.toString().getBytes("utf-8"));
            fos.flush();
            fos.close();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public void generateCPScript(List<String> cp) {
        StringBuilder sb2 = new StringBuilder();
        sb2.append("-cp \"./").append(SBEnhancer.removeSlash(this.classesFolder)).append("\\\n");
        for (String string : cp) {
            String name = string;
            int pos = name.lastIndexOf("/");
            if (pos > -1) {
                name = name.substring(pos + 1);
            }
            if (name.contains("-SNAPSHOT")) {
                sb2.append(":./").append(this.snapshotsFolder).append(name).append("\\\n");
                continue;
            }
            sb2.append(":./").append(this.libsFolder).append(name).append("\\\n");
        }
        sb2.append(":./").append(this.loaderFolder).append("\\\n");
        sb2.append(":./").append(this.metaFolder).append("\\\n");
        sb2.append("\"");
        try {
            File f = new File(this.destDir + this.appFolder + "/cp.arg");
            File p = f.getParentFile();
            if (!p.exists()) {
                p.mkdirs();
            }
            FileOutputStream fos = new FileOutputStream(f);
            fos.write(sb2.toString().getBytes("utf-8"));
            fos.flush();
            fos.close();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public String config() {
        StringBuilder sb = new StringBuilder();
        sb.append("\nsbFile: ").append(this.filename);
        sb.append("\ndestDir: ").append(this.destDir);
        sb.append("\nappFolder: ").append(this.appFolder);
        sb.append("\nlibsFolder: ").append(this.libsFolder);
        sb.append("\nsnapshotsFolder: ").append(this.snapshotsFolder);
        sb.append("\nloaderFolder: ").append(this.loaderFolder);
        sb.append("\nmetaFolder: ").append(this.metaFolder);
        return sb.toString();
    }

    private void updateModificationDate(File folder, long time) {
        folder.setLastModified(time);
        File[] children = folder.listFiles();
        if (children == null) {
            return;
        }
        for (File file : children) {
            file.setLastModified(time);
            if (!file.isDirectory()) continue;
            this.updateModificationDate(file, time);
        }
    }
}

