/*
 * Decompiled with CFR 0.152.
 */
package sk.antons.sbsplitter;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class SBSplitter {
    private String filename;
    private String destDir;
    private String appFolder = "app/";
    private String classesFolder = "classes/";
    private String libsFolder = "libs/";
    private String snapshotsFolder = "snapshots/";
    private String loaderFolder = "loader/";
    private String metaFolder = "meta/";

    public static SBSplitter instance() {
        return new SBSplitter();
    }

    public String filename() {
        return this.filename;
    }

    public SBSplitter filename(String value) {
        this.filename = value;
        return this;
    }

    public String destDir() {
        return this.destDir;
    }

    public SBSplitter destDir(String value) {
        this.destDir = value;
        return this;
    }

    public String appFolder() {
        return this.appFolder;
    }

    public SBSplitter appFolder(String value) {
        this.appFolder = value;
        return this;
    }

    public String classesFolder() {
        return this.classesFolder;
    }

    public SBSplitter classesFolder(String value) {
        this.classesFolder = value;
        return this;
    }

    public String libsFolder() {
        return this.libsFolder;
    }

    public SBSplitter libsFolder(String value) {
        this.libsFolder = value;
        return this;
    }

    public String snapshotsFolder() {
        return this.snapshotsFolder;
    }

    public SBSplitter snapshotsFolder(String value) {
        this.snapshotsFolder = value;
        return this;
    }

    public String loaderFolder() {
        return this.loaderFolder;
    }

    public SBSplitter loaderFolder(String value) {
        this.loaderFolder = value;
        return this;
    }

    public String metaFolder() {
        return this.metaFolder;
    }

    public SBSplitter metaFolder(String value) {
        this.metaFolder = value;
        return this;
    }

    private void unzip() {
        try {
            this.initFolders();
            File dest = new File(this.destDir);
            if (!dest.exists()) {
                dest.mkdirs();
            }
            byte[] buffer = new byte[1024];
            ZipInputStream zis = new ZipInputStream(new FileInputStream(this.filename));
            ZipEntry zipEntry = zis.getNextEntry();
            while (zipEntry != null) {
                if (!zipEntry.isDirectory()) {
                    int len;
                    String name = zipEntry.getName();
                    File newFile = this.newFile(name);
                    FileOutputStream fos = new FileOutputStream(newFile);
                    while ((len = zis.read(buffer)) > 0) {
                        fos.write(buffer, 0, len);
                    }
                    fos.close();
                }
                zipEntry = zis.getNextEntry();
            }
            zis.closeEntry();
            zis.close();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    private File newFile(String name) throws IOException {
        String fullname;
        String simpleName = fullname = this.destDir + this.appFolder;
        fullname = name.startsWith("BOOT-INF/lib/") && name.contains("-SNAPSHOT") ? fullname + this.snapshotsFolder + name.substring(13) : (name.startsWith("BOOT-INF/lib/") ? fullname + this.libsFolder + name.substring(13) : (name.startsWith("BOOT-INF/classes/") ? fullname + this.classesFolder + name.substring(17) : (name.startsWith("org/springframework") ? fullname + this.loaderFolder + name : fullname + this.metaFolder + name)));
        File destFile = new File(fullname);
        String destFilePath = destFile.getCanonicalPath();
        File p = destFile.getParentFile();
        if (!p.exists()) {
            p.mkdirs();
        }
        return destFile;
    }

    private void initFolders() throws IOException {
        String[] folders;
        for (String folder : folders = new String[]{this.snapshotsFolder, this.libsFolder, this.classesFolder, this.loaderFolder, this.metaFolder}) {
            String fullname = this.destDir + this.appFolder + folder;
            File p = new File(fullname);
            if (p.exists()) continue;
            p.mkdirs();
        }
    }

    public void split() {
        this.unzip();
    }

    public String config() {
        StringBuilder sb = new StringBuilder();
        sb.append("\nsbFile: ").append(this.filename);
        sb.append("\ndestDir: ").append(this.destDir);
        sb.append("\nappFolder: ").append(this.appFolder);
        sb.append("\nlibsFolder: ").append(this.libsFolder);
        sb.append("\nsnapshotsFolder: ").append(this.snapshotsFolder);
        sb.append("\nloaderFolder: ").append(this.loaderFolder);
        sb.append("\nmetaFolder: ").append(this.metaFolder);
        return sb.toString();
    }
}

