/*
 * Decompiled with CFR 0.152.
 */
package sk.antons.sbsplitter;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import sk.antons.sbsplitter.Copy;
import sk.antons.sbsplitter.SBEnhancer;
import sk.antons.sbsplitter.SBSplitter;

@Mojo(name="split", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.RUNTIME)
public class SBSplitterMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(property="dockerFile", defaultValue="src/main/docker/Dockerfile", required=false)
    private String dockerFile;
    @Parameter(property="sbFile", defaultValue="target/${project.build.finalName}.jar", required=false)
    private String filename;
    @Parameter(property="destDir", defaultValue="target/sb/", required=false)
    private String destDir;
    @Parameter(property="appDir", defaultValue="app/", required=false)
    private String appFolder;
    @Parameter(property="libsDir", defaultValue="libs/", required=false)
    private String libsFolder;
    @Parameter(property="snapshotsDir", defaultValue="snapshots/", required=false)
    private String snapshotsFolder;
    @Parameter(property="loaderDir", defaultValue="loader/", required=false)
    private String loaderFolder;
    @Parameter(property="metaDir", defaultValue="meta/", required=false)
    private String metaFolder;
    @Parameter(property="copies", required=false)
    private Copy[] copies = null;

    private static String initProperty(String value, String defaultValue, boolean endswithslash) {
        if (value == null) {
            value = defaultValue;
        }
        if (endswithslash && !value.endsWith("/")) {
            value = value + "/";
        }
        return value;
    }

    private void initProperties() {
        this.destDir = SBSplitterMojo.initProperty(this.destDir, "target/sb/", true);
        this.appFolder = SBSplitterMojo.initProperty(this.appFolder, "app/", true);
        this.libsFolder = SBSplitterMojo.initProperty(this.libsFolder, "libs/", true);
        this.snapshotsFolder = SBSplitterMojo.initProperty(this.snapshotsFolder, "snapshots/", true);
        this.loaderFolder = SBSplitterMojo.initProperty(this.loaderFolder, "loader/", true);
        this.metaFolder = SBSplitterMojo.initProperty(this.metaFolder, "meta/", true);
    }

    public void execute() throws MojoExecutionException {
        this.initProperties();
        SBSplitter splitter = SBSplitter.instance().filename(this.filename).destDir(this.destDir).appFolder(this.appFolder).libsFolder(this.libsFolder).snapshotsFolder(this.snapshotsFolder).loaderFolder(this.loaderFolder).metaFolder(this.metaFolder);
        this.printConf();
        this.getLog().info((CharSequence)("[SB split] splitting " + splitter.filename() + " to " + splitter.destDir()));
        splitter.split();
        this.getLog().info((CharSequence)"[SB split] splitting done");
        SBEnhancer enhancer = SBEnhancer.instance().project(this.project).filename(this.filename).destDir(this.destDir).appFolder(this.appFolder).libsFolder(this.libsFolder).snapshotsFolder(this.snapshotsFolder).loaderFolder(this.loaderFolder).metaFolder(this.metaFolder);
        enhancer.enhance(this.getLog());
        this.getLog().info((CharSequence)"[SB split] enhancing done");
        if (this.copies != null) {
            for (Copy copy : this.copies) {
                this.getLog().info((CharSequence)"");
                copy.copy(this.getLog());
            }
        }
        try {
            File f = new File(this.dockerFile);
            if (f.exists()) {
                Files.copy(f.toPath(), new File(this.destDir + "/Dockerfile").toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            this.getLog().info((CharSequence)"[SB split] docker file replaced");
        }
        catch (Exception e) {
            throw new IllegalStateException("unable to copy Dockerfile " + this.dockerFile, e);
        }
    }

    private void printConf() {
        this.getLog().info((CharSequence)("[SB split] conf sbFile: " + this.filename));
        this.getLog().info((CharSequence)("[SB split] conf destDir: " + this.destDir));
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)("[SB split] conf appFolder: " + this.appFolder));
        this.getLog().info((CharSequence)("[SB split] conf libsFolder: " + this.libsFolder));
        this.getLog().info((CharSequence)("[SB split] conf snapshotsFolder: " + this.snapshotsFolder));
        this.getLog().info((CharSequence)("[SB split] conf loaderFolder: " + this.loaderFolder));
        this.getLog().info((CharSequence)("[SB split] conf metaFolder: " + this.metaFolder));
        this.getLog().info((CharSequence)"");
        if (this.copies != null && this.copies.length > 0) {
            this.getLog().info((CharSequence)"");
            for (Copy copy : this.copies) {
                this.getLog().info((CharSequence)"[SB split] conf copy");
                this.getLog().info((CharSequence)("           from: " + copy.getFrom()));
                this.getLog().info((CharSequence)("           to:   " + copy.getTo()));
            }
        }
        this.getLog().info((CharSequence)"");
    }
}

