/*
 * Decompiled with CFR 0.152.
 */
package io.github.cainlara.arguments.manager.core;

import io.github.cainlara.arguments.manager.domain.AMArgument;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;

public final class AMUtility {
    private static AMUtility instance;

    private AMUtility() {
    }

    public static AMUtility getInstance() {
        if (instance == null) {
            instance = new AMUtility();
        }
        return instance;
    }

    public List<AMArgument> getArguments(String argumentStr) {
        if (ObjectUtils.isNotEmpty((Object)argumentStr)) {
            String[] splitted = argumentStr.trim().split(" ");
            return this.getArguments(splitted);
        }
        return Collections.emptyList();
    }

    public List<AMArgument> getArguments(String ... args) {
        ArrayList<AMArgument> argumentsList = new ArrayList<AMArgument>();
        if (ObjectUtils.isNotEmpty((Object)args)) {
            Arrays.asList(args).forEach(arg -> {
                String[] argNameValuePair = arg.split("=");
                if (ObjectUtils.isNotEmpty((Object)argNameValuePair) && argNameValuePair.length == 2) {
                    argumentsList.add(AMArgument.builder().argumentName(argNameValuePair[0].trim()).argumentValue(argNameValuePair[1].trim()).build());
                }
            });
        }
        return argumentsList;
    }

    public AMArgument getArgumentByName(String argumentName, String argumentStr) {
        return this.getArguments(argumentStr).stream().filter(argument -> argument.getArgumentName().equalsIgnoreCase(argumentName)).findFirst().orElse(null);
    }

    public AMArgument getArgumentByName(String argumentName, String ... args) {
        return this.getArguments(args).stream().filter(argument -> argument.getArgumentName().equalsIgnoreCase(argumentName)).findFirst().orElse(null);
    }
}

