/*
 * Decompiled with CFR 0.152.
 */
package io.github.cruisoring;

import io.github.cruisoring.TypeHelper;
import io.github.cruisoring.function.BiConsumerThrowable;
import io.github.cruisoring.function.BiFunctionThrowable;
import io.github.cruisoring.function.BiPredicateThrowable;
import io.github.cruisoring.function.ConsumerThrowable;
import io.github.cruisoring.function.FunctionThrowable;
import io.github.cruisoring.function.HeptaConsumerThrowable;
import io.github.cruisoring.function.HeptaFunctionThrowable;
import io.github.cruisoring.function.HexaConsumerThrowable;
import io.github.cruisoring.function.HexaFunctionThrowable;
import io.github.cruisoring.function.PentaConsumerThrowable;
import io.github.cruisoring.function.PentaFunctionThrowable;
import io.github.cruisoring.function.PredicateThrowable;
import io.github.cruisoring.function.QuadConsumerThrowable;
import io.github.cruisoring.function.QuadFunctionThrowable;
import io.github.cruisoring.function.RunnableThrowable;
import io.github.cruisoring.function.SupplierThrowable;
import io.github.cruisoring.function.TriConsumerThrowable;
import io.github.cruisoring.function.TriFunctionThrowable;
import io.github.cruisoring.function.WithValueReturned;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Functions<R> {
    private static BiFunction<Exception, WithValueReturned, Object> returnDefaultValue = (ex, throwable) -> TypeHelper.getDefaultValue(TypeHelper.getReturnType(throwable));
    public static final Functions ReturnsDefaultValue = new Functions(ex -> {}, returnDefaultValue);
    public static final Functions ThrowsRuntimeException = new Functions();
    public static Functions Default = ReturnsDefaultValue;
    private static Integer processorNumber;
    private final Consumer<Exception> handler;
    private final BiFunction<Exception, WithValueReturned, Object> defaultReturner;

    public static <R> Functions<R> buildFunctions(Consumer<Exception> exceptionHandler, BiFunction<Exception, WithValueReturned, R> defaultValueFactory) {
        Objects.requireNonNull(exceptionHandler);
        Objects.requireNonNull(defaultValueFactory);
        return new Functions<R>(exceptionHandler, defaultValueFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T, R> List<R> applyParallel(FunctionThrowable<T, R> function, List<T> inputs, long timeoutMills) {
        ArrayList callables = new ArrayList();
        inputs.stream().forEach(input -> callables.add(() -> function.apply(input)));
        ExecutorService EXEC = Executors.newCachedThreadPool();
        try {
            List results;
            List list = results = EXEC.invokeAll(callables).stream().map(f -> {
                try {
                    return f.get(timeoutMills, TimeUnit.MINUTES);
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            }).collect(Collectors.toList());
            return list;
        }
        catch (InterruptedException e) {
            List<R> list = null;
            return list;
        }
        finally {
            EXEC.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void runParallel(ConsumerThrowable<T> consumerThrowable, Stream<T> paramStream, long timeoutMills) {
        ArrayList callables = new ArrayList();
        paramStream.forEach(param -> callables.add(() -> {
            consumerThrowable.accept(param);
            return null;
        }));
        ExecutorService EXEC = Executors.newCachedThreadPool();
        try {
            EXEC.invokeAll(callables, timeoutMills, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            EXEC.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runParallel(ConsumerThrowable<Integer> consumerThrowable, int length) {
        if (length < 1) {
            throw new IllegalArgumentException("length must be greater than 0");
        }
        if (processorNumber == null) {
            processorNumber = Runtime.getRuntime().availableProcessors();
        }
        int threadNumer = Integer.min(processorNumber, length / 10);
        ExecutorService EXEC = Executors.newFixedThreadPool(threadNumer);
        int step = length / threadNumer;
        ArrayList<Callable<Void>> callables = new ArrayList<Callable<Void>>();
        try {
            for (int i = 0; i < threadNumer; ++i) {
                int start = i * step;
                int end = Integer.min(length, (i + 1) * step);
                callables.add(() -> {
                    for (int j = start; j < end; ++j) {
                        consumerThrowable.accept(j);
                    }
                    return null;
                });
            }
            EXEC.invokeAll(callables);
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            EXEC.shutdownNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runParallel(List<RunnableThrowable> tasks, long timeoutMills) {
        ArrayList callables = new ArrayList();
        tasks.stream().forEach(runnable -> callables.add(() -> {
            runnable.run();
            return null;
        }));
        ExecutorService EXEC = Executors.newCachedThreadPool();
        try {
            EXEC.invokeAll(callables, timeoutMills, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            EXEC.shutdown();
        }
    }

    private Functions() {
        this.handler = null;
        this.defaultReturner = null;
    }

    public Functions(Consumer<Exception> exceptionHandler, BiFunction<Exception, WithValueReturned, Object> defaultReturner) {
        Objects.requireNonNull(exceptionHandler);
        this.handler = exceptionHandler;
        this.defaultReturner = defaultReturner;
    }

    public void run(RunnableThrowable runnableThrowable) {
        try {
            runnableThrowable.run();
        }
        catch (Exception ex) {
            if (this.handler != null) {
                this.handler.accept(ex);
            }
            throw new RuntimeException(ex);
        }
    }

    public R apply(SupplierThrowable<R> supplierThrowable) {
        try {
            return supplierThrowable.get();
        }
        catch (Exception ex) {
            return (R)(this.handler == null ? null : this.defaultReturner.apply(ex, supplierThrowable));
        }
    }

    public <T> void run(ConsumerThrowable<T> consumer, T t) {
        consumer.withHandler(this.handler).accept(t);
    }

    public <T, U> void run(BiConsumerThrowable<T, U> consumer, T t, U u) {
        consumer.withHandler(this.handler).accept(t, u);
    }

    public <T, U, V> void run(TriConsumerThrowable<T, U, V> consumer, T t, U u, V v) {
        consumer.withHandler(this.handler).accept(t, u, v);
    }

    public <T, U, V, W> void run(QuadConsumerThrowable<T, U, V, W> consumer, T t, U u, V v, W w) {
        consumer.withHandler(this.handler).accept(t, u, v, w);
    }

    public <T, U, V, W, X> void run(PentaConsumerThrowable<T, U, V, W, X> consumer, T t, U u, V v, W w, X x) {
        consumer.withHandler(this.handler).accept(t, u, v, w, x);
    }

    public <T, U, V, W, X, Y> void run(HexaConsumerThrowable<T, U, V, W, X, Y> consumer, T t, U u, V v, W w, X x, Y y) {
        consumer.withHandler(this.handler).accept(t, u, v, w, x, y);
    }

    public <T, U, V, W, X, Y, Z> void run(HeptaConsumerThrowable<T, U, V, W, X, Y, Z> consumer, T t, U u, V v, W w, X x, Y y, Z z) {
        consumer.withHandler(this.handler).accept(t, u, v, w, x, y, z);
    }

    public <T> Boolean test(PredicateThrowable<T> predicate, T t) {
        Predicate<Object> predicate1 = t1 -> {
            try {
                return predicate.test(t1);
            }
            catch (Exception e) {
                return this.defaultReturner == null ? false : (Boolean)this.defaultReturner.apply(e, predicate);
            }
        };
        return predicate1.test(t);
    }

    public <T, U> Boolean test(BiPredicateThrowable<T, U> predicate, T t, U u) {
        BiPredicate<Object, Object> predicate1 = (t1, u1) -> {
            try {
                return predicate.test(t1, u1);
            }
            catch (Exception e) {
                return this.defaultReturner == null ? false : (Boolean)this.defaultReturner.apply(e, predicate);
            }
        };
        return predicate1.test(t, u);
    }

    public <T> R apply(FunctionThrowable<T, R> function, T t) {
        return function.withHandler(this.defaultReturner).apply(t);
    }

    public <T, U> R apply(BiFunctionThrowable<T, U, R> function, T t, U u) {
        return function.withHandler(this.defaultReturner).apply(t, u);
    }

    public <T, U, V> R apply(TriFunctionThrowable<T, U, V, R> function, T t, U u, V v) {
        return function.withHandler(this.defaultReturner).apply(t, u, v);
    }

    public <T, U, V, W> R apply(QuadFunctionThrowable<T, U, V, W, R> function, T t, U u, V v, W w) {
        return function.withHandler(this.defaultReturner).apply(t, u, v, w);
    }

    public <T, U, V, W, X> R apply(PentaFunctionThrowable<T, U, V, W, X, R> function, T t, U u, V v, W w, X x) {
        return function.withHandler(this.defaultReturner).apply(t, u, v, w, x);
    }

    public <T, U, V, W, X, Y> R apply(HexaFunctionThrowable<T, U, V, W, X, Y, R> function, T t, U u, V v, W w, X x, Y y) {
        return function.withHandler(this.defaultReturner).apply(t, u, v, w, x, y);
    }

    public <T, U, V, W, X, Y, Z> R apply(HeptaFunctionThrowable<T, U, V, W, X, Y, Z, R> function, T t, U u, V v, W w, X x, Y y, Z z) {
        return function.withHandler(this.defaultReturner).apply(t, u, v, w, x, y, z);
    }
}

