/*
 * Decompiled with CFR 0.152.
 */
package io.github.cruisoring.repository;

import io.github.cruisoring.function.FunctionThrowable;
import io.github.cruisoring.function.TriConsumerThrowable;
import io.github.cruisoring.utility.Logger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiPredicate;

public class Repository<TKey, TValue>
implements FunctionThrowable<TKey, TValue> {
    public static boolean USE_DEFAULT_CHNAGES_LOG = false;
    public static long DEFAULT_RESET_TIMEOUT = 2000L;
    final Map<TKey, TValue> storage;
    final FunctionThrowable<TKey, TValue> valueFunctionThrowable;
    final TriConsumerThrowable<TKey, TValue, TValue> changesConsumer;

    public Repository(Map<TKey, TValue> map, TriConsumerThrowable<TKey, TValue, TValue> changesConsumer, FunctionThrowable<TKey, TValue> valueFunction) {
        this.storage = map;
        Objects.requireNonNull(valueFunction);
        this.valueFunctionThrowable = valueFunction;
        this.changesConsumer = changesConsumer != null ? changesConsumer : (USE_DEFAULT_CHNAGES_LOG ? this::defualtChangesLog : null);
    }

    public Repository(FunctionThrowable<TKey, TValue> valueFunction) {
        this(new HashMap(), null, valueFunction);
    }

    private void defualtChangesLog(TKey key, TValue oldValue, TValue newValue) {
        Class<?> keyClass = key.getClass();
        TValue value = oldValue == null ? newValue : oldValue;
        Class<?> valueClass = value == null ? null : value.getClass();
        Logger.L("%s<%s,%s>.put(%s: %s -> %s)", this.getClass().getSimpleName(), keyClass.getSimpleName(), valueClass.getSimpleName(), key, oldValue, newValue);
    }

    @Override
    public TValue apply(TKey tKey) throws Exception {
        TValue result;
        Objects.requireNonNull(tKey);
        if (!this.storage.containsKey(tKey)) {
            result = this.valueFunctionThrowable.apply(tKey);
            this.storage.put(tKey, result);
            if (this.changesConsumer != null) {
                this.changesConsumer.accept(tKey, null, result);
            }
        } else {
            result = this.storage.get(tKey);
        }
        return result;
    }

    public TValue update(TKey tKey, TValue existingValue, TValue newValue) throws Exception {
        Objects.requireNonNull(tKey);
        if (Objects.equals(existingValue, newValue)) {
            return existingValue;
        }
        if (this.containsKey(tKey) && !Objects.equals(existingValue, this.storage.get(tKey))) {
            throw new Exception("The existing value of '" + tKey + "' doesn't match with " + existingValue);
        }
        if (!this.containsKey(tKey) && existingValue != null) {
            throw new Exception("The existingValue shall be null when there is no entry of key of " + tKey);
        }
        this.storage.put(tKey, newValue);
        if (this.changesConsumer != null) {
            this.changesConsumer.accept(tKey, existingValue, newValue);
        }
        return newValue;
    }

    public int clear(BiPredicate<TKey, TValue> keyValuePredicate) {
        Objects.requireNonNull(keyValuePredicate);
        int changes = 0;
        Set<TKey> keySet = this.storage.keySet();
        ArrayList<TKey> keyList = new ArrayList<TKey>(keySet);
        for (Object key : keyList) {
            try {
                TValue value = this.storage.get(key);
                if (!keyValuePredicate.test(key, value)) continue;
                this.storage.remove(key, value);
                ++changes;
                if (this.changesConsumer == null) continue;
                this.changesConsumer.accept(key, value, null);
            }
            catch (Exception exception) {}
        }
        return changes;
    }

    public TValue get(TKey tKey, TValue defaultValue) {
        try {
            return this.apply(tKey);
        }
        catch (Exception ex) {
            return defaultValue;
        }
    }

    public boolean containsKey(Object tKey) {
        return this.storage.containsKey(tKey);
    }

    public int getSize() {
        return this.storage.size();
    }
}

