/*
 * Decompiled with CFR 0.152.
 */
package io.github.cruisoring.tuple;

import io.github.cruisoring.tuple.Tuple;
import java.util.Arrays;
import java.util.Objects;

public class Set<T>
extends Tuple {
    public static final Set EMPTY = new Set<Object>((T[])new Object[0]);
    public final Class<T> elementType;

    protected Set(T ... elements) {
        super(elements);
        this.elementType = elements.getClass().getComponentType();
    }

    protected Set(Class<T> elementType, T ... elements) {
        super(elements);
        Objects.requireNonNull(elementType);
        this.elementType = elementType;
    }

    public T[] asArray() {
        return Arrays.copyOf(this.values, this.values.length);
    }

    public T get(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.getLength()) {
            throw new IndexOutOfBoundsException();
        }
        return (T)this.values[index];
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Set)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        Set other = (Set)obj;
        if (!other.canEqual(this) || this.getLength() != ((Tuple)obj).getLength()) {
            return false;
        }
        return super.equals(other);
    }

    @Override
    public boolean canEqual(Object other) {
        return other instanceof Set && ((Set)other).elementType.equals(this.elementType);
    }

    public <R> Set<R> getSetOf(Class<R> clazz) {
        Objects.requireNonNull(clazz);
        if (clazz.equals(this.elementType) || clazz.isAssignableFrom(this.elementType)) {
            return this;
        }
        return EMPTY;
    }

    @Override
    public String toString() {
        return String.format("%s[%s]", this.elementType.getSimpleName(), super.toString());
    }
}

