/*
 * Decompiled with CFR 0.152.
 */
package io.github.cruisoring.utility;

import io.github.cruisoring.Loggable;
import io.github.cruisoring.function.ConsumerThrowable;
import io.github.cruisoring.utility.StringHelper;

public class Logger
implements Loggable {
    private static final String textReset = "\u001b[0m";
    public static Logger Default = new Logger(s -> System.out.println((String)s));
    private final ConsumerThrowable<String> _logging;

    public static void L(String format, Object ... arguments) {
        if (Default != null) {
            String color = "\u001b[0;34m";
            if (StringHelper.containsAnyIgnoreCase(format, "fail", "exception").booleanValue()) {
                color = "\u001b[0;31m";
            } else if (StringHelper.containsAnyIgnoreCase(format, "success", "succeed", "pass").booleanValue()) {
                color = "\u001b[0;32m";
            }
            String reportFormat = format.replaceAll("(%[\\S]+)", String.format("%s$1%s", color, textReset));
            Default.log(reportFormat, arguments);
        }
    }

    public Logger(ConsumerThrowable<String> logging) {
        this._logging = logging;
    }

    @Override
    public void log(String message, Object ... arguments) {
        if (this._logging != null) {
            this._logging.withHandler(null).accept(String.format(message, arguments));
        }
    }
}

