/*
 * Decompiled with CFR 0.152.
 */
package io.github.cruisoring.utility;

import io.github.cruisoring.utility.Logger;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class ResourceHelper {
    public static Class[] getClasses(String packageName) throws Exception {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        assert (classLoader != null);
        String path = packageName.replace('.', '/');
        Enumeration<URL> resources = classLoader.getResources(path);
        ArrayList<File> dirs = new ArrayList<File>();
        while (resources.hasMoreElements()) {
            URL resource = resources.nextElement();
            dirs.add(new File(resource.getFile()));
        }
        ArrayList<Class> classes = new ArrayList<Class>();
        for (File directory : dirs) {
            classes.addAll(ResourceHelper.findClasses(directory, packageName));
        }
        return classes.toArray(new Class[classes.size()]);
    }

    private static List<Class> findClasses(File directory, String packageName) throws ClassNotFoundException {
        File[] files;
        ArrayList<Class> classes = new ArrayList<Class>();
        if (!directory.exists()) {
            return classes;
        }
        for (File file : files = directory.listFiles()) {
            if (file.isDirectory()) {
                assert (!file.getName().contains("."));
                classes.addAll(ResourceHelper.findClasses(file, packageName + "." + file.getName()));
                continue;
            }
            if (!file.getName().endsWith(".class")) continue;
            classes.add(Class.forName(packageName + '.' + file.getName().substring(0, file.getName().length() - 6)));
        }
        return classes;
    }

    public static Boolean isResourceAvailable(String resourceFilename) {
        URL url = ResourceHelper.class.getClassLoader().getResource(resourceFilename);
        return url != null;
    }

    public static String getTextFromResourceFile(String resourceFilename) {
        URL url = ResourceHelper.class.getClassLoader().getResource(resourceFilename);
        if (url == null) {
            return null;
        }
        String sql = null;
        try {
            URI uri = url.toURI();
            byte[] bytes = Files.readAllBytes(Paths.get(uri));
            sql = new String(bytes);
        }
        catch (Exception e) {
            Logger.L(e.getMessage(), new Object[0]);
        }
        return sql;
    }

    public static Map<String, Properties> getAllProperties(String resourcePackagename, Map<String, Properties> result) {
        File[] propertiesFiles;
        ClassLoader classLoader;
        String path;
        File file;
        if (result == null) {
            result = new HashMap<String, Properties>();
        }
        if (!(file = new File(path = (classLoader = ResourceHelper.class.getClassLoader()).getResource(resourcePackagename).getPath())).exists()) {
            Logger.L("Failed to find: %s", resourcePackagename);
            return null;
        }
        for (File f : propertiesFiles = new File(path).listFiles()) {
            if (f.isFile()) {
                ResourceHelper.addFile(f, result);
                continue;
            }
            if (!f.isDirectory()) continue;
            ResourceHelper.addDirectory(f, result);
        }
        return result;
    }

    protected static void addDirectory(File file, Map<String, Properties> result) {
        File[] files;
        for (File f : files = new File(file.getPath()).listFiles()) {
            if (f.isFile()) {
                ResourceHelper.addFile(f, result);
                continue;
            }
            if (!f.isDirectory()) continue;
            ResourceHelper.addDirectory(f, result);
        }
    }

    protected static void addFile(File file, Map<String, Properties> result) {
        String propertiesName = file.getName();
        propertiesName = propertiesName.substring(0, propertiesName.indexOf("."));
        Properties properties = new Properties();
        try {
            properties.load(new FileReader(file));
        }
        catch (IOException e) {
            Logger.L(e.getMessage(), new Object[0]);
            return;
        }
        result.put(propertiesName, properties);
    }
}

