/*
 * Decompiled with CFR 0.152.
 */
package io.github.cruisoring.utility;

import com.sun.media.sound.InvalidFormatException;
import io.github.cruisoring.TypeHelper;
import io.github.cruisoring.function.FunctionThrowable;
import io.github.cruisoring.function.TriConsumerThrowable;
import io.github.cruisoring.repository.Repository;
import io.github.cruisoring.utility.ArrayHelper;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public class StringHelper {
    private static final Repository<Class, FunctionThrowable<String, Object>> stringParsers;
    public static final Function<Object, String[]> defaultToStringForms;
    public static final BiPredicate<String, String> contains;
    public static final BiPredicate<String, String> containsIgnoreCase;

    public static <E extends Enum<E>> E parseEnum(Class<E> enumClass, String enumString) throws Exception {
        Enum[] enumValues = (Enum[])enumClass.getEnumConstants();
        Enum matchedOrFirst = Arrays.stream(enumValues).filter(e -> e.toString().equalsIgnoreCase(enumString)).findFirst().orElse(enumValues[0]);
        return (E)matchedOrFirst;
    }

    private static Object throwsException(String s) throws Exception {
        throw new Exception();
    }

    private static FunctionThrowable<String, Object> getParser(Class clazz) throws Exception {
        Objects.requireNonNull(clazz);
        if (stringParsers.containsKey(clazz)) {
            return stringParsers.get(clazz, null);
        }
        if (TypeHelper.isPrimitive(clazz).booleanValue()) {
            return StringHelper.getParser(TypeHelper.getEquivalentClass(clazz));
        }
        if (Enum.class.isAssignableFrom(clazz)) {
            return s -> StringHelper.parseEnum(clazz, s);
        }
        if (clazz.isArray()) {
            Class<?> componentClass = clazz.getComponentType();
            FunctionThrowable<String, Object> componentParser = StringHelper.getParser(componentClass);
            TriConsumerThrowable<Object, Integer, Object> equivalentSetter = TypeHelper.getArrayElementSetter(componentClass);
            if (componentParser == null || equivalentSetter == null) {
                return StringHelper::throwsException;
            }
            return s -> {
                if (!(s = s.trim()).startsWith("[") || !s.endsWith("]")) {
                    throw new InvalidFormatException("Array types shall be wrapped within '[]' and seperated by ','s.");
                }
                String[] substrings = s.substring(1, s.length() - 1).split(",");
                int length = substrings.length;
                Object parsedValues = ArrayHelper.getNewArray(componentClass, length);
                for (int i = 0; i < length; ++i) {
                    equivalentSetter.accept(parsedValues, i, componentParser.apply(substrings[i]));
                }
                return parsedValues;
            };
        }
        throw new Exception("Not support!");
    }

    public static <T> T parse(String objString, Class<T> objectType, T defaultValue) {
        if (objString == null || objectType == null) {
            return defaultValue;
        }
        try {
            FunctionThrowable<String, Object> parser = stringParsers.apply(objectType);
            return (T)parser.apply(objString);
        }
        catch (Exception ex) {
            return defaultValue;
        }
    }

    private static final Boolean matchAny(BiPredicate<String, String> matcher, String context, String[] keys) {
        if (context == null) {
            return false;
        }
        return Arrays.stream(keys).anyMatch(k -> matcher.test(context, (String)k));
    }

    public static Boolean containsAll(String context, Function<Object, String[]> toStringForms, Object ... keys) {
        if (context == null) {
            return false;
        }
        return Arrays.stream(keys).filter(o -> o != null).allMatch(o -> StringHelper.matchAny(contains, context, (String[])toStringForms.apply(o)));
    }

    public static Boolean containsAll(String context, Object ... keys) {
        return StringHelper.containsAll(context, defaultToStringForms, keys);
    }

    public static Boolean containsAllIgnoreCase(String context, Function<Object, String[]> toStringForms, Object ... keys) {
        if (context == null) {
            return false;
        }
        return Stream.of(keys).filter(o -> o != null).allMatch(o -> StringHelper.matchAny(containsIgnoreCase, context, (String[])toStringForms.apply(o)));
    }

    public static Boolean containsAllIgnoreCase(String context, Object ... keys) {
        return StringHelper.containsAllIgnoreCase(context, defaultToStringForms, keys);
    }

    public static Boolean containsAny(String context, Function<Object, String[]> toStringForms, Object ... keys) {
        if (context == null) {
            return false;
        }
        return Arrays.stream(keys).filter(o -> o != null).anyMatch(o -> StringHelper.matchAny(contains, context, (String[])toStringForms.apply(o)));
    }

    public static Boolean containsAny(String context, Object ... keys) {
        return StringHelper.containsAny(context, defaultToStringForms, keys);
    }

    public static Boolean containsAny(String context, String ... keys) {
        return StringHelper.containsAny(context, defaultToStringForms, (Object[])keys);
    }

    public static Boolean containsAnyIgnoreCase(String context, Function<Object, String[]> toStringForms, Object ... keys) {
        if (context == null) {
            return false;
        }
        return ((Stream)Arrays.stream(keys).filter(o -> o != null).parallel()).anyMatch(o -> StringHelper.matchAny(containsIgnoreCase, context, (String[])toStringForms.apply(o)));
    }

    public static Boolean containsAnyIgnoreCase(String context, Object ... keys) {
        return StringHelper.containsAnyIgnoreCase(context, defaultToStringForms, keys);
    }

    private static /* synthetic */ boolean lambda$static$5(String s, String k) {
        return StringUtils.containsIgnoreCase((CharSequence)s, (CharSequence)k);
    }

    private static /* synthetic */ boolean lambda$static$4(String s, String k) {
        return StringUtils.contains((CharSequence)s, (CharSequence)k);
    }

    /*
     * Exception decompiling
     */
    static {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

