/*
 * Decompiled with CFR 0.152.
 */
package io.github.cruisoring;

import io.github.cruisoring.Functions;
import io.github.cruisoring.function.BiConsumerThrowable;
import io.github.cruisoring.function.FunctionThrowable;
import io.github.cruisoring.function.SupplierThrowable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class Lazy<T>
implements AutoCloseable {
    final SupplierThrowable<T> supplier;
    final BiConsumerThrowable<T, T> actionOnChanges;
    private boolean isInitialized = false;
    private T value = null;
    private boolean isClosed = false;
    protected List<AutoCloseable> dependencies;

    public Lazy(SupplierThrowable<T> supplier) {
        Objects.requireNonNull(supplier);
        this.supplier = supplier;
        this.actionOnChanges = null;
    }

    public Lazy(SupplierThrowable<T> supplier, BiConsumerThrowable<T, T> actionOnChanges) {
        Objects.requireNonNull(supplier);
        this.supplier = supplier;
        this.actionOnChanges = actionOnChanges;
    }

    public <U> Lazy<U> create(FunctionThrowable<T, U> function) {
        Lazy<Object> dependency = new Lazy<Object>(() -> function.apply(this.getValue()));
        if (this.dependencies == null) {
            this.dependencies = new ArrayList<AutoCloseable>();
        }
        this.dependencies.add(dependency);
        return dependency;
    }

    public <U> Lazy<U> create(FunctionThrowable<T, U> function, BiConsumerThrowable<U, U> actionOnChanges) {
        Lazy<Object> dependency = new Lazy<Object>(() -> function.apply(this.getValue()), actionOnChanges);
        if (this.dependencies == null) {
            this.dependencies = new ArrayList<AutoCloseable>();
        }
        this.dependencies.add(dependency);
        return dependency;
    }

    public boolean isValueInitialized() {
        return this.isInitialized;
    }

    public T getValue() {
        if (!this.isInitialized) {
            T oldValue = this.value;
            this.value = this.supplier.withHandler(null).get();
            this.isInitialized = true;
            this.isClosed = false;
            if (this.actionOnChanges != null) {
                Functions.Default.run(this.actionOnChanges, oldValue, this.value);
            }
        }
        return this.value;
    }

    public void closing() {
        if (!this.isClosed) {
            this.isClosed = true;
            if (this.dependencies != null && this.dependencies.size() > 0) {
                for (int i = this.dependencies.size() - 1; i >= 0; --i) {
                    AutoCloseable child = this.dependencies.get(i);
                    if (child instanceof Lazy && ((Lazy)child).isClosed) continue;
                    Functions.Default.run(child::close);
                }
                this.dependencies.clear();
            }
            if (this.isInitialized) {
                this.isInitialized = false;
                if (this.value != null && this.value instanceof AutoCloseable) {
                    Functions.Default.run(((AutoCloseable)this.value)::close);
                }
                T currentValue = this.value;
                this.value = null;
                if (this.actionOnChanges != null) {
                    Functions.Default.run(this.actionOnChanges, currentValue, null);
                }
            }
        }
    }

    @Override
    public void close() throws Exception {
        this.closing();
    }
}

