/*
 * Decompiled with CFR 0.152.
 */
package io.github.cruisoring.tuple;

import io.github.cruisoring.Functions;
import io.github.cruisoring.TypeHelper;
import io.github.cruisoring.tuple.Tuple0;
import io.github.cruisoring.tuple.Tuple1;
import io.github.cruisoring.tuple.Tuple10;
import io.github.cruisoring.tuple.Tuple11;
import io.github.cruisoring.tuple.Tuple12;
import io.github.cruisoring.tuple.Tuple13;
import io.github.cruisoring.tuple.Tuple14;
import io.github.cruisoring.tuple.Tuple15;
import io.github.cruisoring.tuple.Tuple16;
import io.github.cruisoring.tuple.Tuple17;
import io.github.cruisoring.tuple.Tuple18;
import io.github.cruisoring.tuple.Tuple19;
import io.github.cruisoring.tuple.Tuple2;
import io.github.cruisoring.tuple.Tuple20;
import io.github.cruisoring.tuple.Tuple3;
import io.github.cruisoring.tuple.Tuple4;
import io.github.cruisoring.tuple.Tuple5;
import io.github.cruisoring.tuple.Tuple6;
import io.github.cruisoring.tuple.Tuple7;
import io.github.cruisoring.tuple.Tuple8;
import io.github.cruisoring.tuple.Tuple9;
import io.github.cruisoring.tuple.TuplePlus;
import io.github.cruisoring.tuple.TupleSet;
import io.github.cruisoring.tuple.WithValues;
import io.github.cruisoring.utility.ArrayHelper;
import io.github.cruisoring.utility.Logger;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Predicate;

public class Tuple<T>
implements AutoCloseable,
Comparable<Tuple>,
WithValues {
    public static final Tuple0 UNIT = new Tuple0();
    public static final Tuple1 TRUE = new Tuple1<Boolean>(true);
    public static final Tuple1 FALSE = new Tuple1<Boolean>(false);
    protected final Object[] values;
    private Integer _hashCode;
    private int[][] deepLength;
    private String _toString;
    private boolean closed = false;

    protected Tuple(Class<T> elementType, T ... elements) {
        int length = elements == null ? 1 : elements.length;
        Object[] objectArray = this.values = elementType == null ? new Object[length] : (Object[])ArrayHelper.getNewArray(elementType, length);
        if (elements == null) {
            this.values[0] = null;
        } else {
            for (int i = 0; i < length; ++i) {
                this.values[i] = elements[i];
            }
        }
    }

    protected Tuple(Object ... elements) {
        if (elements == null) {
            this.values = new Object[]{null};
        } else {
            int length = elements.length;
            this.values = new Object[length];
            for (int i = 0; i < length; ++i) {
                this.values[i] = elements[i];
            }
        }
    }

    @Override
    public Object getValueAt(int index) {
        if (index < 0 || index >= this.values.length) {
            return null;
        }
        return this.values[index];
    }

    public <T> TupleSet<T> getSetOf(Class<T> clazz) {
        Objects.requireNonNull(clazz);
        try {
            Predicate<Class> predicate = TypeHelper.getClassEqualitor(clazz);
            Class equivalent = TypeHelper.isPrimitive(clazz) != false && !clazz.isArray() ? TypeHelper.getEquivalentClass(clazz) : clazz;
            Boolean isArray = clazz.isArray();
            Class<?> componentType = isArray != false ? clazz.getComponentType() : null;
            int length = this.getLength();
            ArrayList<Object> list = new ArrayList<Object>();
            for (int i = 0; i < length; ++i) {
                Object v = this.values[i];
                if (v != null) {
                    Class<?> vClass = v.getClass();
                    if (equivalent.equals(vClass)) {
                        list.add(v);
                        continue;
                    }
                    if (!predicate.test(vClass)) continue;
                    Object t = TypeHelper.getToEquivalentParallelConverter(vClass).apply(v);
                    list.add(t);
                    continue;
                }
                if (TypeHelper.isPrimitive(clazz).booleanValue()) continue;
                list.add(null);
            }
            Object[] array = list.toArray((Object[])ArrayHelper.getNewArray(equivalent, list.size()));
            return Tuple.setOf(equivalent, array);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public <S> TupleSet<S> getSetOf(Class<S> clazz, Predicate<S> valuePredicate) {
        Objects.requireNonNull(clazz);
        Objects.requireNonNull(valuePredicate);
        ArrayList<Object> matched = new ArrayList<Object>();
        Predicate<Class> classPredicate = TypeHelper.getClassEqualitor(clazz);
        int length = this.getLength();
        for (int i = 0; i < length; ++i) {
            Object v = this.values[i];
            if (v == null) continue;
            try {
                if (!classPredicate.test(v.getClass()) || !valuePredicate.test(v)) continue;
                matched.add(v);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Object[] array = matched.stream().toArray();
        return Tuple.setOf(clazz, array);
    }

    public int getLength() {
        return this.values.length;
    }

    public int[][] getDeepLength() {
        if (this.deepLength == null) {
            this.deepLength = TypeHelper.getDeepLength(this.values);
        }
        return this.deepLength;
    }

    @Override
    public int compareTo(Tuple o) {
        int length = o.getLength();
        int result = this.getLength() - length;
        if (result != 0) {
            return result;
        }
        String thisString = this.toString();
        String oString = o.toString();
        result = thisString.length() - oString.length();
        if (result != 0) {
            return result;
        }
        return thisString.compareTo(oString);
    }

    public int hashCode() {
        if (this._hashCode == null) {
            this._hashCode = TypeHelper.deepHashCode(this.values);
        }
        return this._hashCode;
    }

    public boolean equals(Object obj) {
        int length = this.values.length;
        if (obj == null || !(obj instanceof Tuple) || length != ((Tuple)obj).getLength()) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        Tuple other = (Tuple)obj;
        if (!other.canEqual(this)) {
            return false;
        }
        return TypeHelper.valueEquals((Object)this.values, (Object)other.values, this.getDeepLength(), other.getDeepLength());
    }

    public boolean canEqual(Object obj) {
        return obj instanceof Tuple;
    }

    public String toString() {
        if (this._toString == null) {
            this._toString = TypeHelper.deepToString(this.values);
        }
        return this._toString;
    }

    @Override
    public void close() throws Exception {
        if (!this.closed) {
            for (int i = this.values.length - 1; i >= 0; --i) {
                Object value = this.values[i];
                if (value == null || !(value instanceof AutoCloseable)) continue;
                Functions.Default.run(() -> ((AutoCloseable)value).close());
                Logger.V("%s closed()", value);
            }
            this.closed = true;
            Logger.V("%s.close() run successfully!", this);
        }
    }

    public static Tuple of(Object ... elements) {
        if (elements == null) {
            return Tuple.create(null);
        }
        int length = elements.length;
        switch (length) {
            case 0: {
                return UNIT;
            }
            case 1: {
                return new Tuple1<Object>(elements[0]);
            }
            case 2: {
                return new Tuple2<Object, Object>(elements[0], elements[1]);
            }
            case 3: {
                return new Tuple3<Object, Object, Object>(elements[0], elements[1], elements[2]);
            }
            case 4: {
                return new Tuple4<Object, Object, Object, Object>(elements[0], elements[1], elements[2], elements[3]);
            }
            case 5: {
                return new Tuple5<Object, Object, Object, Object, Object>(elements[0], elements[1], elements[2], elements[3], elements[4]);
            }
            case 6: {
                return new Tuple6<Object, Object, Object, Object, Object, Object>(elements[0], elements[1], elements[2], elements[3], elements[4], elements[5]);
            }
            case 7: {
                return new Tuple7<Object, Object, Object, Object, Object, Object, Object>(elements[0], elements[1], elements[2], elements[3], elements[4], elements[5], elements[6]);
            }
            case 8: {
                return new Tuple8<Object, Object, Object, Object, Object, Object, Object, Object>(elements[0], elements[1], elements[2], elements[3], elements[4], elements[5], elements[6], elements[7]);
            }
            case 9: {
                return new Tuple9<Object, Object, Object, Object, Object, Object, Object, Object, Object>(elements[0], elements[1], elements[2], elements[3], elements[4], elements[5], elements[6], elements[7], elements[8]);
            }
            case 10: {
                return new Tuple10<Object, Object, Object, Object, Object, Object, Object, Object, Object, Object>(elements[0], elements[1], elements[2], elements[3], elements[4], elements[5], elements[6], elements[7], elements[8], elements[9]);
            }
            case 11: {
                return new Tuple11<Object, Object, Object, Object, Object, Object, Object, Object, Object, Object, Object>(elements[0], elements[1], elements[2], elements[3], elements[4], elements[5], elements[6], elements[7], elements[8], elements[9], elements[10]);
            }
            case 12: {
                return new Tuple12<Object, Object, Object, Object, Object, Object, Object, Object, Object, Object, Object, Object>(elements[0], elements[1], elements[2], elements[3], elements[4], elements[5], elements[6], elements[7], elements[8], elements[9], elements[10], elements[11]);
            }
            case 13: {
                return new Tuple13<Object, Object, Object, Object, Object, Object, Object, Object, Object, Object, Object, Object, Object>(elements[0], elements[1], elements[2], elements[3], elements[4], elements[5], elements[6], elements[7], elements[8], elements[9], elements[10], elements[11], elements[12]);
            }
            case 14: {
                return new Tuple14<Object, Object, Object, Object, Object, Object, Object, Object, Object, Object, Object, Object, Object, Object>(elements[0], elements[1], elements[2], elements[3], elements[4], elements[5], elements[6], elements[7], elements[8], elements[9], elements[10], elements[11], elements[12], elements[13]);
            }
            case 15: {
                return new Tuple15<Object, Object, Object, Object, Object, Object, Object, Object, Object, Object, Object, Object, Object, Object, Object>(elements[0], elements[1], elements[2], elements[3], elements[4], elements[5], elements[6], elements[7], elements[8], elements[9], elements[10], elements[11], elements[12], elements[13], elements[14]);
            }
            case 16: {
                return new Tuple16<Object, Object, Object, Object, Object, Object, Object, Object, Object, Object, Object, Object, Object, Object, Object, Object>(elements[0], elements[1], elements[2], elements[3], elements[4], elements[5], elements[6], elements[7], elements[8], elements[9], elements[10], elements[11], elements[12], elements[13], elements[14], elements[15]);
            }
            case 17: {
                return new Tuple17<Object, Object, Object, Object, Object, Object, Object, Object, Object, Object, Object, Object, Object, Object, Object, Object, Object>(elements[0], elements[1], elements[2], elements[3], elements[4], elements[5], elements[6], elements[7], elements[8], elements[9], elements[10], elements[11], elements[12], elements[13], elements[14], elements[15], elements[16]);
            }
            case 18: {
                return new Tuple18<Object, Object, Object, Object, Object, Object, Object, Object, Object, Object, Object, Object, Object, Object, Object, Object, Object, Object>(elements[0], elements[1], elements[2], elements[3], elements[4], elements[5], elements[6], elements[7], elements[8], elements[9], elements[10], elements[11], elements[12], elements[13], elements[14], elements[15], elements[16], elements[17]);
            }
            case 19: {
                return new Tuple19<Object, Object, Object, Object, Object, Object, Object, Object, Object, Object, Object, Object, Object, Object, Object, Object, Object, Object, Object>(elements[0], elements[1], elements[2], elements[3], elements[4], elements[5], elements[6], elements[7], elements[8], elements[9], elements[10], elements[11], elements[12], elements[13], elements[14], elements[15], elements[16], elements[17], elements[18]);
            }
            case 20: {
                return new Tuple20<Object, Object, Object, Object, Object, Object, Object, Object, Object, Object, Object, Object, Object, Object, Object, Object, Object, Object, Object, Object>(elements[0], elements[1], elements[2], elements[3], elements[4], elements[5], elements[6], elements[7], elements[8], elements[9], elements[10], elements[11], elements[12], elements[13], elements[14], elements[15], elements[16], elements[17], elements[18], elements[19]);
            }
        }
        return new TuplePlus<Object, Object, Object, Object, Object, Object, Object, Object, Object, Object, Object, Object, Object, Object, Object, Object, Object, Object, Object, Object>(elements[0], elements[1], elements[2], elements[3], elements[4], elements[5], elements[6], elements[7], elements[8], elements[9], elements[10], elements[11], elements[12], elements[13], elements[14], elements[15], elements[16], elements[17], elements[18], elements[19], Arrays.copyOfRange(elements, 20, length));
    }

    protected static Tuple0 create() {
        return UNIT;
    }

    public static <T> Tuple1<T> create(T t) {
        return new Tuple1<T>(t);
    }

    public static <T, U> Tuple2<T, U> create(T t, U u) {
        return new Tuple2<T, U>(t, u);
    }

    public static <T, U, V> Tuple3<T, U, V> create(T t, U u, V v) {
        return new Tuple3<T, U, V>(t, u, v);
    }

    public static <T, U, V, W> Tuple4<T, U, V, W> create(T t, U u, V v, W w) {
        return new Tuple4<T, U, V, W>(t, u, v, w);
    }

    public static <T, U, V, W, X> Tuple5<T, U, V, W, X> create(T t, U u, V v, W w, X x) {
        return new Tuple5<T, U, V, W, X>(t, u, v, w, x);
    }

    public static <T, U, V, W, X, Y> Tuple6<T, U, V, W, X, Y> create(T t, U u, V v, W w, X x, Y y) {
        return new Tuple6<T, U, V, W, X, Y>(t, u, v, w, x, y);
    }

    public static <T, U, V, W, X, Y, Z> Tuple7<T, U, V, W, X, Y, Z> create(T t, U u, V v, W w, X x, Y y, Z z) {
        return new Tuple7<T, U, V, W, X, Y, Z>(t, u, v, w, x, y, z);
    }

    public static <T, U, V, W, X, Y, Z, A> Tuple8<T, U, V, W, X, Y, Z, A> create(T t, U u, V v, W w, X x, Y y, Z z, A a) {
        return new Tuple8<T, U, V, W, X, Y, Z, A>(t, u, v, w, x, y, z, a);
    }

    public static <T, U, V, W, X, Y, Z, A, B> Tuple9<T, U, V, W, X, Y, Z, A, B> create(T t, U u, V v, W w, X x, Y y, Z z, A a, B b) {
        return new Tuple9<T, U, V, W, X, Y, Z, A, B>(t, u, v, w, x, y, z, a, b);
    }

    public static <T, U, V, W, X, Y, Z, A, B, C> Tuple10<T, U, V, W, X, Y, Z, A, B, C> create(T t, U u, V v, W w, X x, Y y, Z z, A a, B b, C c) {
        return new Tuple10<T, U, V, W, X, Y, Z, A, B, C>(t, u, v, w, x, y, z, a, b, c);
    }

    public static <T, U, V, W, X, Y, Z, A, B, C, D> Tuple11<T, U, V, W, X, Y, Z, A, B, C, D> create(T t, U u, V v, W w, X x, Y y, Z z, A a, B b, C c, D d) {
        return new Tuple11<T, U, V, W, X, Y, Z, A, B, C, D>(t, u, v, w, x, y, z, a, b, c, d);
    }

    public static <T, U, V, W, X, Y, Z, A, B, C, D, E> Tuple12<T, U, V, W, X, Y, Z, A, B, C, D, E> create(T t, U u, V v, W w, X x, Y y, Z z, A a, B b, C c, D d, E e) {
        return new Tuple12<T, U, V, W, X, Y, Z, A, B, C, D, E>(t, u, v, w, x, y, z, a, b, c, d, e);
    }

    public static <T, U, V, W, X, Y, Z, A, B, C, D, E, F> Tuple13<T, U, V, W, X, Y, Z, A, B, C, D, E, F> create(T t, U u, V v, W w, X x, Y y, Z z, A a, B b, C c, D d, E e, F f) {
        return new Tuple13<T, U, V, W, X, Y, Z, A, B, C, D, E, F>(t, u, v, w, x, y, z, a, b, c, d, e, f);
    }

    public static <T, U, V, W, X, Y, Z, A, B, C, D, E, F, G> Tuple14<T, U, V, W, X, Y, Z, A, B, C, D, E, F, G> create(T t, U u, V v, W w, X x, Y y, Z z, A a, B b, C c, D d, E e, F f, G g) {
        return new Tuple14<T, U, V, W, X, Y, Z, A, B, C, D, E, F, G>(t, u, v, w, x, y, z, a, b, c, d, e, f, g);
    }

    public static <T, U, V, W, X, Y, Z, A, B, C, D, E, F, G, H> Tuple15<T, U, V, W, X, Y, Z, A, B, C, D, E, F, G, H> create(T t, U u, V v, W w, X x, Y y, Z z, A a, B b, C c, D d, E e, F f, G g, H h) {
        return new Tuple15<T, U, V, W, X, Y, Z, A, B, C, D, E, F, G, H>(t, u, v, w, x, y, z, a, b, c, d, e, f, g, h);
    }

    public static <T, U, V, W, X, Y, Z, A, B, C, D, E, F, G, H, I> Tuple16<T, U, V, W, X, Y, Z, A, B, C, D, E, F, G, H, I> create(T t, U u, V v, W w, X x, Y y, Z z, A a, B b, C c, D d, E e, F f, G g, H h, I i) {
        return new Tuple16<T, U, V, W, X, Y, Z, A, B, C, D, E, F, G, H, I>(t, u, v, w, x, y, z, a, b, c, d, e, f, g, h, i);
    }

    public static <T, U, V, W, X, Y, Z, A, B, C, D, E, F, G, H, I, J> Tuple17<T, U, V, W, X, Y, Z, A, B, C, D, E, F, G, H, I, J> create(T t, U u, V v, W w, X x, Y y, Z z, A a, B b, C c, D d, E e, F f, G g, H h, I i, J j) {
        return new Tuple17<T, U, V, W, X, Y, Z, A, B, C, D, E, F, G, H, I, J>(t, u, v, w, x, y, z, a, b, c, d, e, f, g, h, i, j);
    }

    public static <T, U, V, W, X, Y, Z, A, B, C, D, E, F, G, H, I, J, K> Tuple18<T, U, V, W, X, Y, Z, A, B, C, D, E, F, G, H, I, J, K> create(T t, U u, V v, W w, X x, Y y, Z z, A a, B b, C c, D d, E e, F f, G g, H h, I i, J j, K k) {
        return new Tuple18<T, U, V, W, X, Y, Z, A, B, C, D, E, F, G, H, I, J, K>(t, u, v, w, x, y, z, a, b, c, d, e, f, g, h, i, j, k);
    }

    public static <T, U, V, W, X, Y, Z, A, B, C, D, E, F, G, H, I, J, K, L> Tuple19<T, U, V, W, X, Y, Z, A, B, C, D, E, F, G, H, I, J, K, L> create(T t, U u, V v, W w, X x, Y y, Z z, A a, B b, C c, D d, E e, F f, G g, H h, I i, J j, K k, L l) {
        return new Tuple19<T, U, V, W, X, Y, Z, A, B, C, D, E, F, G, H, I, J, K, L>(t, u, v, w, x, y, z, a, b, c, d, e, f, g, h, i, j, k, l);
    }

    public static <T, U, V, W, X, Y, Z, A, B, C, D, E, F, G, H, I, J, K, L, M> Tuple20<T, U, V, W, X, Y, Z, A, B, C, D, E, F, G, H, I, J, K, L, M> create(T t, U u, V v, W w, X x, Y y, Z z, A a, B b, C c, D d, E e, F f, G g, H h, I i, J j, K k, L l, M m) {
        return new Tuple20<T, U, V, W, X, Y, Z, A, B, C, D, E, F, G, H, I, J, K, L, M>(t, u, v, w, x, y, z, a, b, c, d, e, f, g, h, i, j, k, l, m);
    }

    public static <T, U, V, W, X, Y, Z, A, B, C, D, E, F, G, H, I, J, K, L, M> TuplePlus<T, U, V, W, X, Y, Z, A, B, C, D, E, F, G, H, I, J, K, L, M> create(T t, U u, V v, W w, X x, Y y, Z z, A a, B b, C c, D d, E e, F f, G g, H h, I i, J j, K k, L l, M m, Object ... others) {
        return new TuplePlus<T, U, V, W, X, Y, Z, A, B, C, D, E, F, G, H, I, J, K, L, M>(t, u, v, w, x, y, z, a, b, c, d, e, f, g, h, i, j, k, l, m, others);
    }

    public static <T> TupleSet<T> setOf(T ... elements) {
        if (elements == null) {
            return (TupleSet)Functions.ReturnsDefaultValue.apply(xva$0 -> new TupleSet<Object>((T[])new Object[]{xva$0}), elements);
        }
        Class<?> elementType = elements.getClass().getComponentType();
        return new TupleSet(elementType, elements);
    }

    public static <T> TupleSet<T> setOf(Class<T> elementType, T[] elements) {
        return new TupleSet<T>(elementType, elements);
    }

    public static <T> TupleSet<T> setOf(Collection<T> collection, Class<? extends T> clazz) {
        Objects.requireNonNull(collection);
        Object[] array = collection.toArray((Object[])Array.newInstance(clazz, 0));
        return Tuple.setOf(array);
    }
}

