/*
 * Decompiled with CFR 0.152.
 */
package io.github.cruisoring.tuple;

import io.github.cruisoring.tuple.Tuple;
import java.util.Arrays;
import java.util.Objects;

public class TupleSet<T>
extends Tuple {
    public final Class<T> elementType;

    protected TupleSet(T ... elements) {
        super(elements);
        this.elementType = elements.getClass().getComponentType();
    }

    protected TupleSet(Class<T> elementType, T ... elements) {
        super(elementType, elements);
        Objects.requireNonNull(elementType);
        this.elementType = elementType;
    }

    public T[] asArray() {
        return Arrays.copyOf(this.values, this.values.length);
    }

    public T get(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.getLength()) {
            throw new IndexOutOfBoundsException();
        }
        return (T)this.values[index];
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof TupleSet)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        TupleSet other = (TupleSet)obj;
        if (!other.canEqual(this) || this.getLength() != ((Tuple)obj).getLength()) {
            return false;
        }
        return super.equals(other);
    }

    @Override
    public boolean canEqual(Object other) {
        return other instanceof TupleSet && ((TupleSet)other).elementType.equals(this.elementType);
    }

    @Override
    public String toString() {
        return String.format("%s[%s]", this.elementType.getSimpleName(), super.toString());
    }
}

