/*
 * Decompiled with CFR 0.152.
 */
package io.github.cruisoring.utility;

import io.github.cruisoring.tuple.Tuple3;
import io.github.cruisoring.utility.LogLevel;
import io.github.cruisoring.utility.Pipe;
import io.github.cruisoring.utility.StringHelper;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class Logger {
    public static final String PercentageAscii = "&#37";
    public static final String LoggerName = Logger.class.getName();
    public static final String[] automationNeglibles = new String[]{LoggerName};
    public static final String SunReflect = "sun.reflect";
    public static final String[] platformNeglibles = new String[]{"sun.reflect"};
    public static final int DefaultStackCount = 3;
    public static final Boolean MeasurePerformanceEnabled = false;
    public static final String ANSI_RESET = "\u001b[0m";
    public static final String ANSI_BLACK = "\u001b[30m";
    public static final String ANSI_RED = "\u001b[31m";
    public static final String ANSI_LIGHT_YELLOW = "\u001b[93m";
    public static final String ANSI_YELLOW = "\u001b[33m";
    public static final String ANSI_BLUE = "\u001b[34m";
    public static final String ANSI_PURPLE = "\u001b[35m";
    public static final String ANSI_CYAN = "\u001b[36m";
    public static final String ANSI_WHITE = "\u001b[37m";
    public static final String ANSI_BOLD = "\u001b[1m";
    public static final String ANSI_UNBOLD = "\u001b[21m";
    public static final String ANSI_UNDERLINE = "\u001b[4m";
    public static final String ANSI_STOP_UNDERLINE = "\u001b[24m";
    public static final String ANSI_BLINK = "\u001b[5m";
    public static final String RESET = "\u001b[0m";
    public static final String BLACK = "\u001b[0;30m";
    public static final String RED = "\u001b[0;31m";
    public static final String GREEN = "\u001b[0;32m";
    public static final String YELLOW = "\u001b[0;33m";
    public static final String BLUE = "\u001b[0;34m";
    public static final String PURPLE = "\u001b[0;35m";
    public static final String CYAN = "\u001b[0;36m";
    public static final String WHITE = "\u001b[0;37m";
    public static final String BLACK_BOLD = "\u001b[1;30m";
    public static final String RED_BOLD = "\u001b[1;31m";
    public static final String GREEN_BOLD = "\u001b[1;32m";
    public static final String YELLOW_BOLD = "\u001b[1;33m";
    public static final String BLUE_BOLD = "\u001b[1;34m";
    public static final String PURPLE_BOLD = "\u001b[1;35m";
    public static final String CYAN_BOLD = "\u001b[1;36m";
    public static final String WHITE_BOLD = "\u001b[1;37m";
    public static final String BLACK_UNDERLINED = "\u001b[4;30m";
    public static final String RED_UNDERLINED = "\u001b[4;31m";
    public static final String GREEN_UNDERLINED = "\u001b[4;32m";
    public static final String YELLOW_UNDERLINED = "\u001b[4;33m";
    public static final String BLUE_UNDERLINED = "\u001b[4;34m";
    public static final String PURPLE_UNDERLINED = "\u001b[4;35m";
    public static final String CYAN_UNDERLINED = "\u001b[4;36m";
    public static final String WHITE_UNDERLINED = "\u001b[4;37m";
    public static final String BLACK_BACKGROUND = "\u001b[40m";
    public static final String DARK_GRAY_BACKGROUND = "\u001b[100m";
    public static final String RED_BACKGROUND = "\u001b[101m";
    public static final String GREEN_BACKGROUND = "\u001b[102m";
    public static final String YELLOW_BACKGROUND = "\u001b[103m";
    public static final String BLUE_BACKGROUND = "\u001b[104m";
    public static final String PURPLE_BACKGROUND = "\u001b[105m";
    public static final String CYAN_BACKGROUND = "\u001b[106m";
    public static final String WHITE_BACKGROUND = "\u001b[107m";
    static final BiFunction<LogLevel, String, String> defaultMessageFormmater = (level, time) -> {
        String label = String.format("[%s]@%s:", Character.valueOf(StringUtils.upperCase((String)level.toString()).charAt(0)), LocalDateTime.now().format(DateTimeFormatter.ISO_LOCAL_TIME));
        switch (level) {
            case verbose: {
                return String.format("%s%s %s%s", "\u001b[107m\u001b[0;34m", label, time, "\u001b[0m");
            }
            case debug: {
                return String.format("%s%s %s%s", PURPLE_UNDERLINED, label, time, "\u001b[0m");
            }
            case info: {
                return String.format("%s%s %s%s", "\u001b[106m\u001b[0;30m", label, time, "\u001b[0m");
            }
            case warning: {
                return String.format("%s%s %s%s", "\u001b[103m\u001b[4;35m", label, time, "\u001b[0m");
            }
            case error: {
                return String.format("%s%s %s%s", "\u001b[101m\u001b[1;30m", label, time, "\u001b[0m");
            }
        }
        return String.format("%s %s%s", label, time, "\u001b[0m");
    };
    static final Function<LogLevel, Integer> getDefaultStackCount = level -> {
        switch (level) {
            case verbose: {
                return 5;
            }
            case debug: {
                return 3;
            }
            case info: {
                return 3;
            }
            case warning: {
                return 5;
            }
            case error: {
                return 8;
            }
        }
        return 0;
    };
    private static final Pipe<String> recentExceptionMessages = new Pipe(10);
    static String lastMessage;
    static Logger DefaultLogger;
    public final Consumer<String> output;
    private final EnumSet<LogLevel> levels;
    private final BiFunction<LogLevel, String, String> messageFormatter;
    private final Function<LogLevel, Integer> stackCountFun;
    LocalDateTime lastMessageUntil = LocalDateTime.MIN;

    public static String getStackTrace() {
        return Logger.getStackTrace(3);
    }

    public static String getStackTrace(int stackCount) {
        if (stackCount == 0) {
            return "";
        }
        List<String> stacks = Logger.getStackTraceElements(stackCount);
        AtomicInteger counter = new AtomicInteger();
        String result = stacks.stream().map(s -> String.format("%s%s", StringUtils.repeat((String)" ", (int)(2 * counter.getAndIncrement())), s)).collect(Collectors.joining("\r\n"));
        return result;
    }

    public static List<String> getStackTraceElements(int stackCount) {
        StackTraceElement[] stacks = Thread.currentThread().getStackTrace();
        List stackDescriptions = Arrays.stream(stacks).map(stack -> stack.toString()).collect(Collectors.toList());
        int first = -1;
        int last = -1;
        for (int i = 0; i < stackDescriptions.size(); ++i) {
            String desc = (String)stackDescriptions.get(i);
            if (first == -1 && !StringHelper.containsAny(desc, automationNeglibles).booleanValue()) continue;
            if (last == -1 && StringHelper.containsAny(desc, automationNeglibles).booleanValue()) {
                first = i;
                continue;
            }
            if (last == -1) {
                first = i;
                last = stackDescriptions.size();
                continue;
            }
            if (!StringHelper.containsAny(desc, platformNeglibles).booleanValue()) continue;
            last = i;
            break;
        }
        int total = last - first;
        if (stackCount > 0 && stackCount < total) {
            first = last - stackCount;
        } else if (stackCount < 0 && total > -stackCount) {
            last = first - stackCount;
        }
        stackCount = Math.min(total, Math.abs(stackCount));
        return stackDescriptions.stream().skip(first).limit(stackCount).collect(Collectors.toList());
    }

    static Logger logException(LogLevel logLevel, Exception ex) {
        if (DefaultLogger != null) {
            String message = ex.getMessage();
            if (message == null && StringUtils.equalsIgnoreCase((CharSequence)message, (CharSequence)lastMessage)) {
                return DefaultLogger;
            }
            Tuple3<Boolean, String, String> tuple = recentExceptionMessages.pushIfAbsent(message);
            if (((Boolean)tuple.getFirst()).booleanValue() && StringUtils.isNotEmpty((CharSequence)((CharSequence)tuple.getSecond()))) {
                DefaultLogger.log(logLevel, message);
                String stackTrace = Logger.getStackTrace(getDefaultStackCount.apply(logLevel));
                DefaultLogger.log(logLevel, stackTrace);
            } else {
                message = (message == null ? ex.toString() : message).substring(0, message.indexOf(10));
                DefaultLogger.log(logLevel, String.format("Same error as recent one: %s", message));
            }
            if (recentExceptionMessages.isFull()) {
                recentExceptionMessages.pop();
            }
        }
        return DefaultLogger;
    }

    public static Timer M() {
        if (DefaultLogger == null || !MeasurePerformanceEnabled.booleanValue()) {
            return null;
        }
        Consumer<String> output = Logger.DefaultLogger.output;
        return new Timer(output, Timer.highlightTimerFormatter);
    }

    public static Logger V(Exception ex) {
        return Logger.logException(LogLevel.verbose, ex);
    }

    public static Logger D(Exception ex) {
        return Logger.logException(LogLevel.debug, ex);
    }

    public static Logger I(Exception ex) {
        return Logger.logException(LogLevel.info, ex);
    }

    public static Logger W(Exception ex) {
        return Logger.logException(LogLevel.warning, ex);
    }

    public static Logger E(Exception ex) {
        return Logger.logException(LogLevel.error, ex);
    }

    public static Logger V(String format, Object ... args) {
        if (DefaultLogger != null) {
            DefaultLogger.log(LogLevel.verbose, format, args);
        }
        return DefaultLogger;
    }

    public static Logger D(String format, Object ... args) {
        if (DefaultLogger != null) {
            DefaultLogger.log(LogLevel.debug, format, args);
        }
        return DefaultLogger;
    }

    public static Logger I(String format, Object ... args) {
        if (DefaultLogger != null) {
            DefaultLogger.log(LogLevel.info, format, args);
        }
        return DefaultLogger;
    }

    public static Logger W(String format, Object ... args) {
        if (DefaultLogger != null) {
            DefaultLogger.log(LogLevel.warning, format, args);
        }
        return DefaultLogger;
    }

    public static Logger E(String format, Object ... args) {
        if (DefaultLogger != null) {
            DefaultLogger.log(LogLevel.error, format, args);
        }
        return DefaultLogger;
    }

    public static String tryFormatString(String format, Object ... args) {
        Objects.requireNonNull(format);
        try {
            String formatted = String.format(format, args);
            formatted = formatted.replaceAll(PercentageAscii, "%");
            return formatted;
        }
        catch (Exception e) {
            CharSequence[] argStrings = (String[])Arrays.stream(args).map(arg -> arg.toString()).toArray(String[]::new);
            return String.format("MalFormated format: '%s'\nargs: '%s'", format, String.join((CharSequence)", ", argStrings));
        }
    }

    public Logger(Consumer<String> output, BiFunction<LogLevel, String, String> formatter, Function<LogLevel, Integer> stackCountFunction, LogLevel first, LogLevel ... rest) {
        this.output = output;
        this.messageFormatter = formatter;
        this.levels = EnumSet.of(first, rest);
        this.stackCountFun = stackCountFunction;
    }

    public Logger(Consumer<String> output, BiFunction<LogLevel, String, String> formatter, LogLevel first, LogLevel ... rest) {
        this(output, formatter, getDefaultStackCount, first, rest);
    }

    public Logger(Consumer<String> output, LogLevel first, LogLevel ... rest) {
        this(output, defaultMessageFormmater, first, rest);
    }

    public void log(LogLevel level, String message) {
        if (this.output != null && this.levels.contains((Object)level) && (!StringUtils.equals((CharSequence)lastMessage, (CharSequence)message) || LocalDateTime.now().isAfter(this.lastMessageUntil))) {
            lastMessage = message;
            this.lastMessageUntil = LocalDateTime.now().plusSeconds(10L);
            String finalOutput = this.messageFormatter.apply(level, message);
            this.output.accept(finalOutput);
        }
    }

    public void log(Message message) {
        this.log(message.level, message.content);
    }

    public void log(LogLevel level, String format, Object ... args) {
        this.log(level, Logger.tryFormatString(format, args));
    }

    public void log(LogLevel level, Exception ex) {
        int stackCount = this.stackCountFun.apply(level);
        if (stackCount != 0) {
            String stackTrace = Logger.getStackTrace(this.stackCountFun.apply(level));
            this.log(level, Logger.tryFormatString("%s:%s\r\n%s", ex.getClass().getSimpleName(), ex.getMessage(), stackTrace));
        } else {
            this.log(level, Logger.tryFormatString("%s: %s", ex.getClass().getSimpleName(), ex.getMessage()));
        }
    }

    public void verbose(String format, Object ... args) {
        this.log(LogLevel.verbose, Logger.tryFormatString(format, args));
    }

    public void debug(String format, Object ... args) {
        this.log(LogLevel.debug, Logger.tryFormatString(format, args));
    }

    public void info(String format, Object ... args) {
        this.log(LogLevel.info, Logger.tryFormatString(format, args));
    }

    public void warning(String format, Object ... args) {
        this.log(LogLevel.warning, Logger.tryFormatString(format, args));
    }

    public void error(String format, Object ... args) {
        this.log(LogLevel.error, Logger.tryFormatString(format, args));
    }

    static {
        DefaultLogger = new Logger(System.out::println, LogLevel.verbose, LogLevel.debug, LogLevel.info, LogLevel.warning, LogLevel.error);
    }

    public static class Timer
    implements AutoCloseable {
        private static final Pattern pattern = Pattern.compile("(\\w+\\.\\w+\\(.*?)$");
        public static final Function<String, String> defaultTimerFormatter = s -> String.format("%s%s", "\u001b[0m", s);
        public static final Function<String, String> highlightTimerFormatter = s -> String.format("%s%s%s%s", Logger.ANSI_RED, Logger.YELLOW_BACKGROUND, s, "\u001b[0m");
        private final Consumer<String> output;
        private final Function<String, String> formatter;
        private final String entryPoint;
        private final long startTime;

        public static String getClassMethod(String stackTrace) {
            Matcher matcher = pattern.matcher(stackTrace);
            return matcher.find() ? matcher.group() : "";
        }

        public Timer(Consumer<String> output, Function<String, String> formatter) {
            this.output = output;
            this.formatter = formatter;
            List<String> stacks = Logger.getStackTraceElements(-3);
            this.entryPoint = stacks.stream().map(Timer::getClassMethod).collect(Collectors.joining(" <- "));
            this.startTime = System.currentTimeMillis();
        }

        public Timer(Consumer<String> output) {
            this(output, defaultTimerFormatter);
        }

        @Override
        public void close() throws Exception {
            if (this.output != null) {
                String message = String.format("%dms: %s", System.currentTimeMillis() - this.startTime, this.entryPoint);
                message = this.formatter.apply(message);
                this.output.accept(message);
            }
        }
    }

    public class Message {
        public final LogLevel level;
        public final String content;

        public Message(LogLevel l, String c) {
            this.level = l;
            this.content = c;
        }
    }
}

