/*
 * Decompiled with CFR 0.152.
 */
package io.github.cruisoring.utility;

import io.github.cruisoring.tuple.Tuple;
import io.github.cruisoring.tuple.Tuple3;
import io.github.cruisoring.utility.Logger;
import java.time.Duration;
import java.util.LinkedList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Stream;

public class Pipe<T> {
    public static final Duration DefaultMinTimeoutDuration = Duration.ofMillis(100L);
    LinkedList<T> queue = new LinkedList();
    Lock lock = new ReentrantLock();
    Condition notFull = this.lock.newCondition();
    Condition notEmpty = this.lock.newCondition();
    private int capacity;
    private Duration minTimeoutDuration;

    public Pipe(int capacity) {
        this.capacity = capacity;
        this.minTimeoutDuration = DefaultMinTimeoutDuration;
    }

    public Pipe(int capacity, Duration minTimeoutDuration) {
        if (minTimeoutDuration.isNegative() || minTimeoutDuration.isZero()) {
            minTimeoutDuration = DefaultMinTimeoutDuration;
        }
        this.capacity = capacity;
        this.minTimeoutDuration = minTimeoutDuration;
    }

    public int size() {
        return this.queue.size();
    }

    public boolean isFull() {
        return this.size() >= this.capacity;
    }

    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    public int indexOf(T item) {
        return this.queue.indexOf(item);
    }

    public Stream<T> stream() {
        return this.queue.stream();
    }

    public Tuple3<Boolean, T, String> pushIfAbsent(T item) {
        int index = this.indexOf(item);
        if (index == -1) {
            return this.push(item);
        }
        return Tuple.create(false, item, "Item already exist");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tuple3<Boolean, T, String> push(T item, Duration timeout) {
        boolean isLocked = false;
        if (timeout == null || timeout.compareTo(this.minTimeoutDuration) < 0) {
            timeout = this.minTimeoutDuration;
        }
        long timeoutNanos = timeout.toNanos();
        try {
            Comparable<Boolean> awaitResult;
            this.lock.lock();
            isLocked = true;
            while (this.queue.size() >= this.capacity) {
                awaitResult = this.notFull.await(timeoutNanos, TimeUnit.NANOSECONDS);
                if (awaitResult.booleanValue()) continue;
                this.lock.unlock();
                isLocked = false;
                Tuple3<Boolean, T, String> tuple3 = Tuple.create(false, item, "Timeout with full pipe.");
                return tuple3;
            }
            this.queue.add(item);
            this.notEmpty.signal();
            this.lock.unlock();
            isLocked = false;
            Logger.V("@%d>>>>%s", Thread.currentThread().getId(), item);
            awaitResult = Tuple.create(true, item, null);
            return awaitResult;
        }
        catch (Exception e) {
            Logger.W(e);
            Tuple3<Boolean, T, String> tuple3 = Tuple.create(false, item, e.getMessage());
            return tuple3;
        }
        finally {
            if (isLocked) {
                this.lock.unlock();
            }
        }
    }

    public Tuple3<Boolean, T, String> push(T item) {
        return this.push(item, this.minTimeoutDuration);
    }

    public CompletableFuture<Tuple3<Boolean, T, String>> pushAsync(T item, Duration timeout) {
        CompletableFuture<Tuple3<Boolean, T, String>> result = CompletableFuture.supplyAsync(() -> this.push(item, timeout));
        return result;
    }

    public CompletableFuture<Tuple3<Boolean, T, String>> pushAsync(T item) {
        CompletableFuture<Tuple3<Boolean, T, String>> result = CompletableFuture.supplyAsync(() -> this.push(item));
        return result;
    }

    public Tuple3<Boolean, T, String> pop(T item) {
        int index = this.queue.indexOf(item);
        if (index == -1) {
            return Tuple.create(false, null, String.format("No such item: %s", item));
        }
        T removed = this.queue.remove(index);
        if (removed == item) {
            return Tuple.create(true, removed, null);
        }
        return Tuple.create(false, removed, String.format("Removed '%s' is not matched with '%s'", removed, item));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tuple3<Boolean, T, String> pop(Duration timeout) {
        boolean isLocked = false;
        if (timeout == null || timeout.compareTo(this.minTimeoutDuration) < 0) {
            timeout = this.minTimeoutDuration;
        }
        long timeoutNanos = timeout.toNanos();
        try {
            this.lock.lock();
            isLocked = true;
            while (this.queue.isEmpty()) {
                Boolean awaitResult = this.notEmpty.await(timeoutNanos, TimeUnit.NANOSECONDS);
                if (awaitResult.booleanValue()) continue;
                this.lock.unlock();
                isLocked = false;
                Tuple3<Boolean, Object, String> tuple3 = Tuple.create(false, null, "Timeout with empty pipe.");
                return tuple3;
            }
            T item = this.queue.remove();
            this.notFull.signal();
            this.lock.unlock();
            isLocked = false;
            Logger.V("@%d <<<< %s", Thread.currentThread().getId(), item);
            Tuple3<Boolean, T, Object> tuple3 = Tuple.create(true, item, null);
            return tuple3;
        }
        catch (Exception e) {
            Logger.W(e);
            Tuple3<Boolean, Object, String> tuple3 = Tuple.create(false, null, e.getMessage());
            return tuple3;
        }
        finally {
            if (isLocked) {
                this.lock.unlock();
            }
        }
    }

    public Tuple3<Boolean, T, String> pop() {
        return this.pop(this.minTimeoutDuration);
    }

    public CompletableFuture<Tuple3<Boolean, T, String>> popAsync(Duration timeout) {
        CompletableFuture<Tuple3<Boolean, T, String>> result = CompletableFuture.supplyAsync(() -> this.pop(timeout));
        return result;
    }

    public CompletableFuture<Tuple3<Boolean, T, String>> popAsync() {
        return this.popAsync(this.minTimeoutDuration);
    }
}

