/*
 * Decompiled with CFR 0.152.
 */
package io.github.cruisoring;

import io.github.cruisoring.Functions;
import io.github.cruisoring.Revokable;
import io.github.cruisoring.TypeHelper;
import io.github.cruisoring.logger.CompositeLogger;
import io.github.cruisoring.logger.ConsoleLogger;
import io.github.cruisoring.logger.ILogger;
import io.github.cruisoring.logger.InMemoryLogger;
import io.github.cruisoring.logger.LogLevel;
import io.github.cruisoring.logger.Logger;
import io.github.cruisoring.throwables.RunnableThrowable;
import io.github.cruisoring.throwables.SupplierThrowable;
import io.github.cruisoring.utility.ArrayHelper;
import io.github.cruisoring.utility.StringHelper;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.function.Predicate;

public class Asserts {
    public static LogLevel defaultLogLevel = LogLevel.info;

    protected static String log(String format, Object ... args) {
        if (Logger.Default != null) {
            Logger.Default.log(defaultLogLevel, format, args);
        }
        return StringHelper.tryFormatString(format, args);
    }

    public static boolean fail(String format, Object ... args) {
        throw new IllegalStateException(Asserts.log(format, args));
    }

    public static void assertAllTrue(boolean first, boolean ... expressions) {
        if (!first) {
            throw new IllegalStateException(Asserts.log("The first expresion is false.", new Object[0]));
        }
        int length = expressions.length;
        for (int i = 0; i < length; ++i) {
            if (expressions[i]) continue;
            throw new IllegalStateException(Asserts.log("The %dth expresion is false.", i));
        }
    }

    public static void assertAllFalse(boolean first, boolean ... expressions) {
        if (first) {
            throw new IllegalStateException(Asserts.log("The first expression is true", new Object[0]));
        }
        int length = expressions.length;
        for (int i = 0; i < length; ++i) {
            if (!expressions[i]) continue;
            throw new IllegalStateException(Asserts.log("The %dth expression is true", 1 + i));
        }
    }

    public static <T> void assertAllNull(T first, T ... others) {
        if (first != null) {
            throw new IllegalStateException(Asserts.log("The first object is not null: %s", TypeHelper.deepToString(first)));
        }
        int length = others.length;
        for (int i = 0; i < length; ++i) {
            if (others[i] == null) continue;
            throw new NullPointerException(Asserts.log("The %dth object is not null: %s", i + 1, TypeHelper.deepToString(others[i])));
        }
    }

    public static <T> void assertAllNotNull(T reference, T ... others) {
        if (reference == null) {
            throw new NullPointerException(Asserts.log("The first object is null", new Object[0]));
        }
        int length = others.length;
        if (length == 0 && reference.getClass().isArray()) {
            length = Array.getLength(reference);
            for (int i = 0; i < length; ++i) {
                if (Array.get(reference, i) != null) continue;
                throw new NullPointerException(Asserts.log("The %dth object is null!", i + 1));
            }
        } else {
            for (int i = 0; i < length; ++i) {
                if (others[i] != null) continue;
                throw new NullPointerException(Asserts.log("The %dth object is null!", i + 1));
            }
        }
    }

    public static void assertTrue(boolean expression, String format, Object ... args) {
        if (!expression) {
            throw new IllegalStateException(Asserts.log(format, args));
        }
    }

    public static void assertFalse(boolean expression, String format, Object ... args) {
        if (expression) {
            throw new IllegalStateException(Asserts.log(format, args));
        }
    }

    public static void assertNull(Object object, String format, Object ... args) {
        if (object != null) {
            throw new IllegalStateException(Asserts.log(format, args));
        }
    }

    public static void assertNotNull(Object object, String format, Object ... args) {
        if (object == null) {
            throw new NullPointerException(Asserts.log(format, args));
        }
    }

    public static void assertEquals(Object expected, Object actual, boolean matchTypeExactly) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected == null) {
            throw new IllegalStateException(Asserts.log("%s !== %s", "null", TypeHelper.deepToString(actual)));
        }
        if (actual == null) {
            throw new IllegalStateException(Asserts.log("%s !== %s", TypeHelper.deepToString(expected), "null"));
        }
        if (matchTypeExactly && expected.getClass() != actual.getClass()) {
            throw new IllegalStateException(Asserts.log("Expect value of type %s, but actual value is of type %s", expected.getClass().getSimpleName(), actual.getClass().getSimpleName()));
        }
        if (!TypeHelper.valueEquals(expected, actual)) {
            throw new IllegalStateException(Asserts.log("%s !== %s", TypeHelper.deepToString(expected), TypeHelper.deepToString(actual)));
        }
    }

    public static void assertNotEquals(Object expected, Object actual, boolean matchTypeExactly) {
        if (expected == null && actual == null) {
            throw new IllegalStateException(Asserts.log("Both values are nulls.", new Object[0]));
        }
        if (expected == null || actual == null) {
            return;
        }
        if (matchTypeExactly && expected.getClass() != actual.getClass()) {
            return;
        }
        if (TypeHelper.valueEquals(expected, actual)) {
            throw new IllegalStateException(Asserts.log("%s !=== %s", TypeHelper.deepToString(expected), TypeHelper.deepToString(actual)));
        }
    }

    public static void assertEquals(Object expected, Object actual) {
        Asserts.assertEquals(expected, actual, false);
    }

    public static void assertNotEquals(Object expected, Object actual) {
        Asserts.assertNotEquals(expected, actual, false);
    }

    public static <T> boolean isAllMatched(Predicate<T> predicate, Collection<T> collection) {
        Asserts.assertAllNotNull(collection, predicate);
        Iterator<T> iterator = collection.iterator();
        int index = 0;
        while (iterator.hasNext()) {
            T next = iterator.next();
            ++index;
            if (predicate.test(next)) continue;
            Logger.V("Failed to test the %dth element '%s'", index, next);
            return false;
        }
        return true;
    }

    public static <T> boolean isAllMatched(Predicate<T> predicate, Object target) {
        Asserts.assertAllNotNull(target, predicate);
        if (target instanceof Collection) {
            return Asserts.isAllMatched(predicate, (Collection)target);
        }
        if (!target.getClass().isArray()) {
            return predicate.test(target);
        }
        int length = Array.getLength(target);
        for (int i = 0; i < length; ++i) {
            Object next = Array.get(target, i);
            if (predicate.test(next)) continue;
            Logger.V("Failed to test the %dth element '%s'", i, next);
            return false;
        }
        return true;
    }

    public static <T> boolean isAllMatched(Predicate<T> predicate, T first, T ... others) {
        Asserts.assertAllNotNull(predicate, new Predicate[0]);
        Object[] aggregation = ArrayHelper.mergeVarargsFirst(others, first);
        return Asserts.isAllMatched(predicate, aggregation);
    }

    public static <T> boolean isAnyMatched(Predicate<T> predicate, Collection<T> collection) {
        Asserts.assertAllNotNull(collection, predicate);
        Iterator<T> iterator = collection.iterator();
        int index = 0;
        while (iterator.hasNext()) {
            T next = iterator.next();
            ++index;
            if (!predicate.test(next)) continue;
            Logger.V("The %dth element '%s' passed the test", index, next);
            return true;
        }
        return false;
    }

    public static <T> boolean isAnyMatched(Predicate<T> predicate, Object target) {
        Asserts.assertAllNotNull(target, predicate);
        if (target instanceof Collection) {
            return Asserts.isAllMatched(predicate, (Collection)target);
        }
        if (!target.getClass().isArray()) {
            return predicate.test(target);
        }
        int length = Array.getLength(target);
        for (int i = 0; i < length; ++i) {
            Object next = Array.get(target, i);
            if (!predicate.test(next)) continue;
            Logger.V("The %dth element '%s' passed the test", i, next);
            return true;
        }
        return false;
    }

    public static <T> boolean isAnyMatched(Predicate<T> predicate, T first, T ... others) {
        Asserts.assertAllNotNull(predicate, new Predicate[0]);
        Object[] aggregation = ArrayHelper.mergeVarargsFirst(others, first);
        return Asserts.isAnyMatched(predicate, aggregation);
    }

    public static <R> R checkNotNull(R reference, String format, Object ... args) {
        if (reference == null) {
            throw new NullPointerException(Asserts.log(format, args));
        }
        return reference;
    }

    public static <T> T checkNoneNulls(T reference, Object ... others) {
        if (reference == null) {
            throw new NullPointerException(Asserts.log("the first argument is null", new Object[0]));
        }
        int length = others.length;
        if (length == 0 && reference.getClass().isArray()) {
            length = Array.getLength(reference);
            if (length == 0) {
                throw new UnsupportedOperationException(Asserts.log("the optional arguments shall not be included", new Object[0]));
            }
            for (int i = 0; i < length; ++i) {
                if (Array.get(reference, i) != null) continue;
                throw new NullPointerException(Asserts.log("The %dth reference is null!", i + 1));
            }
            return (T)Array.get(reference, 0);
        }
        for (int i = 0; i < length; ++i) {
            if (others[i] != null) continue;
            throw new NullPointerException(Asserts.log("The %dth reference is null!", i + 1));
        }
        return reference;
    }

    public static <R> R assertException(SupplierThrowable<R> supplier, Class<? extends Exception> exceptionClass, Object ... keywords) {
        Asserts.assertAllNotNull(supplier, exceptionClass);
        try {
            supplier.get();
        }
        catch (Exception e) {
            if (e.getClass() != exceptionClass) {
                throw new IllegalStateException(Asserts.log("Unexpected type of Exception: expected is %s, actual is %s.", exceptionClass.getSimpleName(), e.getClass().getSimpleName()));
            }
            if (keywords != null && keywords.length > 0) {
                if (StringHelper.containsAll(e.getMessage(), keywords)) {
                    return null;
                }
                CharSequence[] keyStrings = (String[])Arrays.stream(keywords).map(o -> o == null ? "null" : o.toString()).toArray(String[]::new);
                throw new IllegalStateException(Asserts.log("Some keys (%s) are missing: %s", String.join((CharSequence)", ", keyStrings), e.getMessage()));
            }
            return null;
        }
        throw new IllegalStateException(Asserts.log("No exception of %s thrown", exceptionClass.getSimpleName()));
    }

    public static void assertException(RunnableThrowable runnableThrowable, Class<? extends Exception> exceptionClass, Object ... keywords) {
        try {
            runnableThrowable.run();
        }
        catch (Exception e) {
            if (e.getClass() != exceptionClass) {
                throw new IllegalStateException(Asserts.log("Unexpected type of Exception: expected is %s, actual is %s.", exceptionClass.getSimpleName(), e.getClass().getSimpleName()));
            }
            if (keywords != null && keywords.length > 0 && !StringHelper.containsAll(e.getMessage(), keywords)) {
                CharSequence[] keyStrings = (String[])Arrays.stream(keywords).map(o -> o == null ? "null" : o.toString()).toArray(String[]::new);
                throw new IllegalStateException(Asserts.log("Some keys (%s) are missing: %s", String.join((CharSequence)", ", keyStrings), e.getMessage()));
            }
            return;
        }
        throw new IllegalStateException(Asserts.log("No exception of %s thrown", exceptionClass.getSimpleName()));
    }

    /*
     * Exception decompiling
     */
    public static <R> R assertLogging(SupplierThrowable<R> supplier, Object ... expectations) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void assertLogging(RunnableThrowable runnableThrowable, Object ... expectations) {
        String history;
        InMemoryLogger memoryLogger = new InMemoryLogger();
        ILogger[] iLoggerArray = new ILogger[2];
        iLoggerArray[0] = new ConsoleLogger(System.out::println);
        iLoggerArray[1] = memoryLogger;
        CompositeLogger logger = new CompositeLogger(LogLevel.verbose, iLoggerArray);
        try {
            try (Revokable<ILogger> revokable = Logger.useInScope(logger);
                 Revokable<LogLevel> revokable2 = Logger.setLevelInScope(LogLevel.verbose);){
                runnableThrowable.withHandler(Functions::logAndReturnsNull).run();
            }
            history = memoryLogger.getHistory();
        }
        catch (Throwable throwable) {
            String history2 = memoryLogger.getHistory();
            if (!StringHelper.containsAllIgnoreCase(history2, expectations)) {
                Logger.getDefault().log(defaultLogLevel, "'%s' doesn't contain all: %s", history2, TypeHelper.deepToString(expectations));
                Asserts.fail("Failed with containsAllIgnoreCase", new Object[0]);
            }
            throw throwable;
        }
        if (!StringHelper.containsAllIgnoreCase(history, expectations)) {
            Logger.getDefault().log(defaultLogLevel, "'%s' doesn't contain all: %s", history, TypeHelper.deepToString(expectations));
            Asserts.fail("Failed with containsAllIgnoreCase", new Object[0]);
        }
    }
}

