/*
 * Decompiled with CFR 0.152.
 */
package io.github.cruisoring;

import io.github.cruisoring.Asserts;
import io.github.cruisoring.logger.LogLevel;
import io.github.cruisoring.logger.Logger;
import io.github.cruisoring.throwables.ConsumerThrowable;
import io.github.cruisoring.throwables.FunctionThrowable;
import io.github.cruisoring.throwables.PredicateThrowable;
import io.github.cruisoring.throwables.RunnableThrowable;
import io.github.cruisoring.throwables.SupplierThrowable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Functions {
    public static LogLevel defaultExceptionLogLevel = LogLevel.debug;
    private static final Integer processorNumber = Runtime.getRuntime().availableProcessors();
    public static long defaultDelayMills = 100L;
    static Function<Exception, Object> defaultExceptionHandler = Functions::returnsNull;

    public static Function<Exception, Object> getDefaultExceptionHandler() {
        return defaultExceptionHandler;
    }

    public static boolean setDefaultExceptionHandler(Function<Exception, Object> handler) {
        if (handler == null || handler == defaultExceptionHandler) {
            return false;
        }
        defaultExceptionHandler = handler;
        return true;
    }

    public static Object returnsNull(Exception exception) {
        return null;
    }

    public static Object returnsFalse(Exception exception) {
        return false;
    }

    public static Object returnsTrue(Exception exception) {
        return true;
    }

    public static Object throwsIllegalStateException(Exception cause) {
        throw new IllegalStateException(cause.getClass().getSimpleName(), cause);
    }

    public static Object logAndReturnsNull(Exception cause) {
        Logger.getDefault().log(defaultExceptionLogLevel, cause);
        return null;
    }

    public static Object logThenThrows(Exception cause) {
        Functions.logAndReturnsNull(cause);
        return Functions.throwsIllegalStateException(cause);
    }

    public static void tryRun(RunnableThrowable runnableThrowable) {
        runnableThrowable.withHandler(defaultExceptionHandler).run();
    }

    public static <R> R tryGet(SupplierThrowable<R> supplierThrowable) {
        return supplierThrowable.withHandler(defaultExceptionHandler).get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T, R> List<R> applyParallel(FunctionThrowable<T, R> function, List<T> inputs, long timeoutMills) {
        ArrayList callables = new ArrayList();
        inputs.stream().forEach(input -> callables.add(() -> function.apply(input)));
        ExecutorService EXEC = Executors.newCachedThreadPool();
        try {
            List results;
            List list = results = EXEC.invokeAll(callables).stream().map(f -> {
                try {
                    return f.get(timeoutMills, TimeUnit.MINUTES);
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            }).collect(Collectors.toList());
            return list;
        }
        catch (InterruptedException e) {
            List<R> list = null;
            return list;
        }
        finally {
            EXEC.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void runParallel(ConsumerThrowable<T> consumerThrowable, Stream<T> paramStream, long timeoutMills) {
        ArrayList callables = new ArrayList();
        paramStream.forEach(param -> callables.add(() -> {
            consumerThrowable.accept(param);
            return null;
        }));
        ExecutorService EXEC = Executors.newCachedThreadPool();
        try {
            EXEC.invokeAll(callables, timeoutMills, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            EXEC.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void withElementsParallel(ConsumerThrowable<Integer> consumerThrowable, int length) {
        if (length < 1) {
            throw new IllegalArgumentException("length must be greater than 0");
        }
        int threadNumer = Integer.min(processorNumber, length / 10);
        ExecutorService EXEC = Executors.newFixedThreadPool(threadNumer);
        int step = length / threadNumer;
        ArrayList<Callable<Void>> callables = new ArrayList<Callable<Void>>();
        try {
            for (int i = 0; i < threadNumer; ++i) {
                int start = i * step;
                int end = Integer.min(length, (i + 1) * step);
                callables.add(() -> {
                    for (int j = start; j < end; ++j) {
                        consumerThrowable.accept(j);
                    }
                    return null;
                });
            }
            EXEC.invokeAll(callables);
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            EXEC.shutdownNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runParallel(List<RunnableThrowable> tasks, long timeoutMills) {
        ArrayList callables = new ArrayList();
        tasks.stream().forEach(runnable -> callables.add(() -> {
            runnable.run();
            return null;
        }));
        ExecutorService EXEC = Executors.newCachedThreadPool();
        try {
            EXEC.invokeAll(callables, timeoutMills, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            EXEC.shutdown();
        }
    }

    public static void sleep(long timeMills) {
        try {
            if (timeMills > 0L) {
                TimeUnit.MILLISECONDS.sleep(timeMills);
            }
        }
        catch (InterruptedException e) {
            Logger.getDefault().log(defaultExceptionLogLevel, e);
        }
    }

    public static boolean testUntil(SupplierThrowable<Boolean> predicate, long timeoutMillis, RunnableThrowable action, long delayMills, long initialDelayMills) {
        long now;
        Asserts.assertAllTrue(predicate != null, timeoutMillis >= 0L, delayMills > 0L, initialDelayMills >= 0L);
        long start = now = System.currentTimeMillis();
        long until = now + timeoutMillis;
        if (initialDelayMills > 0L) {
            Functions.sleep(initialDelayMills);
        }
        Throwable lastException = null;
        while (now < until) {
            block6: {
                try {
                    if (predicate.get().booleanValue()) {
                        return true;
                    }
                    if (action != null) {
                        action.run();
                    }
                }
                catch (Exception e) {
                    if (lastException != null && lastException.getMessage() == e.getMessage()) break block6;
                    lastException = e;
                    Logger.getDefault().log(defaultExceptionLogLevel, e);
                }
            }
            now = System.currentTimeMillis();
            long sleepToNext = delayMills - (now - start) % delayMills;
            Functions.sleep(sleepToNext);
        }
        return false;
    }

    public static boolean testUntil(SupplierThrowable<Boolean> predicate, long timeoutMillis, RunnableThrowable action) {
        return Functions.testUntil(predicate, timeoutMillis, action, defaultDelayMills, 0L);
    }

    public static boolean testUntil(SupplierThrowable<Boolean> predicate, long timeoutMillis) {
        return Functions.testUntil(predicate, timeoutMillis, null);
    }

    public static <T> T tryGet(SupplierThrowable<T> valueGetter, long timeoutMillis, PredicateThrowable<T> predicate, long delayMills) {
        long now;
        Asserts.assertAllTrue(valueGetter != null, timeoutMillis >= 0L, predicate != null, delayMills > 0L);
        long start = now = System.currentTimeMillis();
        long until = now + timeoutMillis;
        Throwable lastException = null;
        while (now < until) {
            block4: {
                try {
                    T result = valueGetter.tryGet();
                    if (predicate.test(result)) {
                        return result;
                    }
                }
                catch (Exception e) {
                    if (lastException != null && lastException.getMessage() == e.getMessage()) break block4;
                    lastException = e;
                    Logger.getDefault().log(defaultExceptionLogLevel, e);
                }
            }
            now = System.currentTimeMillis();
            long sleepToNext = delayMills - (now - start) % delayMills;
            Functions.sleep(sleepToNext);
        }
        return null;
    }

    public static <T> T tryGet(SupplierThrowable<T> valueGetter, long timeoutMillis) {
        return (T)Functions.tryGet(valueGetter, timeoutMillis, t -> t != null, defaultDelayMills);
    }
}

