/*
 * Decompiled with CFR 0.152.
 */
package io.github.cruisoring;

import io.github.cruisoring.Asserts;
import io.github.cruisoring.tuple.Tuple;
import io.github.cruisoring.tuple.Tuple2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class Range
implements Comparable<Range> {
    public static final long INFINITE_LENGTH = Long.MAX_VALUE;
    public static final Integer NEGATIVE_INFINITY = Integer.MIN_VALUE;
    public static final Integer POSITIVE_INFINITY = Integer.MAX_VALUE;
    public static final long POSITIVE_INFINITE_LONG = new Long(POSITIVE_INFINITY.intValue());
    public static final Range ALL_INT = new Range(NEGATIVE_INFINITY, POSITIVE_INFINITY);
    public static final Range NONE = new Range(0, 0);
    private static final int _RUN_PARALLEL = 100;
    private static final Predicate<Tuple2<Range, Range>> overlapPredicate = tuple -> ((Range)tuple.getFirst()).overlaps((Range)tuple.getSecond());
    private final long _size;
    private final int _start;
    private final int _end;

    public static Range ofLength(int length) {
        Asserts.assertTrue(length >= 0, "Length shall not be negative value: " + length, new Object[0]);
        return length == 0 ? NONE : new Range(0, length);
    }

    public static Range open(int startExclusive, int endExclusive) {
        Asserts.assertTrue(startExclusive > NEGATIVE_INFINITY + 1, "To represent infinitive range below endEnclusive, use belowOpen(endExclusive)", new Object[0]);
        Asserts.assertTrue(endExclusive < POSITIVE_INFINITY - 1, "To represent range above startExclusive, use aboveOpen(startExclusive)", new Object[0]);
        return new Range(startExclusive + 1, endExclusive);
    }

    public static Range closed(int startInclusive, int endInclusive) {
        Asserts.assertTrue(startInclusive > NEGATIVE_INFINITY + 1, "To represent infinitive range below endEnclusive, use belowClosed(endInclusive)", new Object[0]);
        Asserts.assertTrue(endInclusive < POSITIVE_INFINITY - 1, "To represent range above startExclusive, use aboveClosed(startInclusive)", new Object[0]);
        return new Range(startInclusive, endInclusive + 1);
    }

    public static Range openClosed(int startExclusive, int endInclusive) {
        Asserts.assertTrue(startExclusive > NEGATIVE_INFINITY + 1, "To represent infinitive range below endEnclusive, use belowOpen(endExclusive)", new Object[0]);
        Asserts.assertTrue(endInclusive < POSITIVE_INFINITY - 1, "To represent range above startExclusive, use aboveClosed(startInclusive)", new Object[0]);
        return new Range(startExclusive + 1, endInclusive + 1);
    }

    public static Range closedOpen(int startInclusive, int endExclusive) {
        Asserts.assertTrue(startInclusive > NEGATIVE_INFINITY + 1, "To represent infinitive range below endEnclusive, use belowClosed(endInclusive)", new Object[0]);
        Asserts.assertTrue(endExclusive < POSITIVE_INFINITY - 1, "To represent range above startExclusive, use aboveOpen(startExclusive)", new Object[0]);
        return new Range(startInclusive, endExclusive);
    }

    public static Range aboveClosed(int startInclusive) {
        return startInclusive + 1 > NEGATIVE_INFINITY + 1 ? new Range(startInclusive, POSITIVE_INFINITY) : ALL_INT;
    }

    public static Range aboveOpen(int startExclusive) {
        return startExclusive > NEGATIVE_INFINITY + 1 ? new Range(startExclusive + 1, POSITIVE_INFINITY) : ALL_INT;
    }

    public static Range belowClosed(int endInclusive) {
        return endInclusive < POSITIVE_INFINITY - 1 ? new Range(NEGATIVE_INFINITY, endInclusive + 1) : ALL_INT;
    }

    public static Range belowOpen(int endExclusive) {
        return endExclusive < POSITIVE_INFINITY - 1 ? new Range(NEGATIVE_INFINITY, endExclusive) : ALL_INT;
    }

    public static boolean withinLength(Range range, Integer length) {
        Asserts.assertAllTrue(range != null, length >= 0);
        return range != null && range._start >= 0 && range._end <= length;
    }

    public static List<Range> indexesToRanges(Collection<Integer> indexes) {
        Asserts.assertAllNotNull(indexes, new Collection[0]);
        Asserts.assertAllTrue(indexes.size() % 2 == 0, new boolean[0]);
        return Range._indexesToRanges(indexes);
    }

    static List<Range> _indexesToRanges(Collection<Integer> indexes) {
        int size = indexes.size();
        Iterator<Integer> iterator = indexes.iterator();
        ArrayList<Range> ranges = new ArrayList<Range>();
        while (iterator.hasNext()) {
            Integer startIndex = iterator.next();
            Integer endIndex = iterator.next();
            Range range = Range.closed(startIndex, endIndex);
            ranges.add(range);
        }
        return Collections.unmodifiableList(ranges);
    }

    public static List<Integer> getIndexesInRange(List<Integer> allIndexes, Range range) {
        Asserts.assertAllNotNull(allIndexes, range);
        if (allIndexes.isEmpty()) {
            return new ArrayList<Integer>();
        }
        Collections.sort(allIndexes, Comparator.naturalOrder());
        return Range._getIndexesInRange(allIndexes, range);
    }

    private static List<Integer> _getIndexesInRange(List<Integer> allIndexes, Range range) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        int count = allIndexes.size();
        Integer lower = range.getStartInclusive();
        Integer upper = range.getEndInclusive();
        if (count == 0 || lower > allIndexes.get(count - 1) || upper < allIndexes.get(0)) {
            return result;
        }
        boolean belowRange = true;
        for (int i = 0; i < count; ++i) {
            Integer index = allIndexes.get(i);
            if (belowRange) {
                if (index < lower) continue;
                if (range.contains(index)) {
                    result.add(index);
                } else if (index > upper) {
                    return result;
                }
                belowRange = false;
                continue;
            }
            if (range.contains(index)) {
                result.add(index);
                continue;
            }
            if (index <= upper) continue;
            return result;
        }
        return result;
    }

    private static List<Range> getPairsWithValueRanges(Set<Range> nameRangeSet, Collection<Range> valueRanges, Set<Integer> indicatorIndexes) {
        ArrayList<Range> nvpRanges = new ArrayList<Range>();
        for (Range valueRange : valueRanges) {
            Range nameRange = nameRangeSet.stream().filter(scope -> scope.getEndInclusive() < valueRange.getStartInclusive()).sorted(Comparator.comparing(Range::getEndInclusive).reversed()).findFirst().orElse(null);
            if (nameRange == null) continue;
            Range gapRange = valueRange.gapWith(nameRange);
            List colonsWithin = indicatorIndexes.stream().filter(i -> gapRange.contains((int)i)).collect(Collectors.toList());
            Asserts.assertTrue(colonsWithin.size() == 1, String.format("Failed to get one single indictor between '%s' and '%s'", nameRange, valueRange), new Object[0]);
            Range nameValueRange = nameRange.intersectionWith(valueRange);
            nameRangeSet.remove(nameRange);
            indicatorIndexes.remove(colonsWithin.get(0));
            nvpRanges.add(nameValueRange);
        }
        return nvpRanges;
    }

    private static List<Range> _getNamedValueRanges(Set<Range> nameRangeSet, Set<Integer> indicatorIndexes, List<Integer> sortedEnderIndexes) {
        ArrayList<Range> nvpRanges = new ArrayList<Range>();
        for (Integer joinerIndex : indicatorIndexes) {
            Range nameRange = nameRangeSet.stream().filter(r -> r.getEndInclusive() < joinerIndex).sorted(Comparator.comparing(Range::getEndInclusive).reversed()).findFirst().orElse(null);
            if (nameRange == null) {
                Asserts.checkNotNull(nameRange, "Failed to locate the name range right before COLON at " + joinerIndex, new Object[0]);
            }
            Integer endIndex = sortedEnderIndexes.stream().filter(i -> i > joinerIndex).sorted().findFirst().orElse(null);
            Asserts.checkNotNull(endIndex, "Failed to find the end of value after COLON at " + joinerIndex, new Object[0]);
            Range range = Range.closedOpen(nameRange.getStartInclusive(), endIndex);
            nvpRanges.add(range);
        }
        return nvpRanges;
    }

    public static List<Range> indexesToRanges(Collection<Integer> startIndexes, Collection<Integer> endIndexes) {
        Asserts.assertAllNotNull(startIndexes, endIndexes);
        int size = startIndexes.size();
        Asserts.assertAllTrue(size == endIndexes.size(), new boolean[0]);
        return Range._indexesToRanges(startIndexes, endIndexes);
    }

    static List<Range> _indexesToRanges(Collection<Integer> startIndexes, Collection<Integer> endIndexes) {
        TreeSet<Integer> sortedSet = new TreeSet<Integer>(startIndexes);
        sortedSet.addAll(endIndexes);
        ArrayList<Range> ranges = new ArrayList<Range>();
        for (int i = startIndexes.size() - 1; i >= 0; --i) {
            Integer start = null;
            Integer end = null;
            for (Integer index : sortedSet) {
                if (start == null || startIndexes.contains(index)) {
                    start = index;
                    continue;
                }
                end = index;
                break;
            }
            ranges.add(Range.closed(start, end));
            sortedSet.remove(start);
            sortedSet.remove(end);
        }
        return ranges;
    }

    public static List<Tuple2<Range, Range>> getRangePairs(Collection<Range> ranges1, Collection<Range> ranges2, Predicate<Tuple2<Range, Range>> predicate) {
        Asserts.assertAllNotNull(ranges1, ranges2, predicate);
        int size1 = ranges1.size();
        int size2 = ranges2.size();
        int combinations = size1 * size2;
        if (combinations == 0) {
            return new ArrayList<Tuple2<Range, Range>>();
        }
        Stream options = ranges1.stream().flatMap(x -> ranges2.stream().map(y -> Tuple.create(x, y)));
        List<Tuple2<Range, Range>> result = combinations < 100 ? options.filter(predicate).collect(Collectors.toList()) : ((Stream)options.parallel()).filter(predicate).collect(Collectors.toList());
        return result;
    }

    public static List<Tuple2<Range, Range>> getOverlappedRangePairs(Collection<Range> ranges1, Collection<Range> ranges2) {
        return Range.getRangePairs(ranges1, ranges2, overlapPredicate);
    }

    public static String subString(CharSequence charSequence, Range range) {
        Asserts.assertAllNotNull(charSequence, new CharSequence[0]);
        Asserts.assertAllTrue(Range.withinLength(range, charSequence.length()), new boolean[0]);
        return charSequence.subSequence(range.getStartInclusive(), range.getEndExclusive()).toString();
    }

    protected Range(int startInclusive, int endExclusive) {
        Asserts.assertTrue(startInclusive <= endExclusive, "Range startInclusive %d shall not be greater or equal to endExclusive %d.", startInclusive, endExclusive);
        this._start = startInclusive <= NEGATIVE_INFINITY + 1 ? NEGATIVE_INFINITY : startInclusive;
        this._end = endExclusive > POSITIVE_INFINITY - 1 ? POSITIVE_INFINITY : endExclusive;
        this._size = this._start == NEGATIVE_INFINITY || this._end == POSITIVE_INFINITY ? Long.MAX_VALUE : new Long(this._end) - new Long(this._start);
    }

    public long size() {
        return this._size;
    }

    public boolean isEmpty() {
        return this._size == 0L;
    }

    public Stream<Integer> getStream() {
        if (this._size == 0L) {
            return Stream.empty();
        }
        if (this._start == NEGATIVE_INFINITY && this._end == POSITIVE_INFINITY) {
            throw new IllegalStateException("Cannot get stream for all integers");
        }
        if (this._size != Long.MAX_VALUE) {
            return IntStream.range(this._start, this._end).boxed();
        }
        if (this._start == NEGATIVE_INFINITY) {
            return IntStream.iterate(this._end - 1, i -> i - 1).boxed();
        }
        if (this._end == POSITIVE_INFINITY) {
            return IntStream.iterate(this._start, i -> i + 1).boxed();
        }
        throw new IllegalStateException(String.format("Failed to define the process when _start=%d and _end=%d.", this._start, this._end));
    }

    public boolean contains(int index) {
        return this._start <= index && index < this._end;
    }

    public boolean containsAll(List<Integer> indexes) {
        Asserts.assertAllNotNull(indexes, new List[0]);
        if (this._size == 0L) {
            return false;
        }
        if (indexes.isEmpty()) {
            return true;
        }
        Collections.sort(indexes);
        return this.contains(indexes.get(0)) && (indexes.size() == 0 || this.contains(indexes.get(indexes.size() - 1)));
    }

    public boolean containsAll(int ... indexes) {
        if (this._size == 0L) {
            return false;
        }
        if (indexes.length == 0) {
            return true;
        }
        for (int value : indexes) {
            if (this.contains(value)) continue;
            return false;
        }
        return true;
    }

    public boolean contains(Range other) {
        Asserts.assertAllNotNull(other, new Range[0]);
        return this._start <= other._start && this._end >= other._end;
    }

    public boolean isConnected(Range other) {
        Asserts.assertAllNotNull(other, new Range[0]);
        return this._start <= other._end && other._start <= this._end;
    }

    public boolean overlaps(Range other) {
        Asserts.assertAllNotNull(other, new Range[0]);
        if (this.isEmpty() || other.isEmpty()) {
            return false;
        }
        if (this._start <= other._start) {
            return this._end > other._start;
        }
        return other._end > this._start;
    }

    public Range unionWith(Range other) {
        Asserts.assertAllNotNull(other, new Range[0]);
        int minStart = Math.min(this._start, other._start);
        int maxEnd = Math.max(this._end, other._end);
        if (minStart == NEGATIVE_INFINITY && maxEnd == POSITIVE_INFINITY) {
            return ALL_INT;
        }
        if (minStart == this._start && maxEnd == this._end) {
            return this;
        }
        if (minStart == other._start && maxEnd == other._end) {
            return other;
        }
        return new Range(minStart, maxEnd);
    }

    public Range intersectionWith(Range other) {
        Asserts.assertAllNotNull(other, new Range[0]);
        if (!this.overlaps(other)) {
            return NONE;
        }
        int start = Math.max(this._start, other._start);
        int end = Math.min(this._end, other._end);
        return new Range(start, end);
    }

    public Range gapWith(Range other) {
        Asserts.assertAllNotNull(other, new Range[0]);
        if (this._start == other._start || this._end == other._end || this._start == other._end || this._end == other._start) {
            return NONE;
        }
        if (this._start < other._start) {
            return this._end >= other._start ? NONE : Range.closedOpen(this._end, other._start);
        }
        return other._end >= this._start ? NONE : Range.closedOpen(other._end, this._start);
    }

    public int getStartInclusive() {
        return this._start;
    }

    public int getStartExclusive() {
        return this._start == NEGATIVE_INFINITY ? NEGATIVE_INFINITY : this._start - 1;
    }

    public int getEndInclusive() {
        return this._end == POSITIVE_INFINITY ? POSITIVE_INFINITY : this._end - 1;
    }

    public int getEndExclusive() {
        return this._end;
    }

    public List<Range> getChildRanges(TreeSet<Range> ranges) {
        ArrayList<Range> children = new ArrayList<Range>();
        Range lastChild = null;
        for (Range range : ranges) {
            if (this._end < range._start) {
                return children;
            }
            if (this.equals(range) || !this.contains(range) || lastChild != null && lastChild.contains(range)) continue;
            children.add(range);
            lastChild = range;
        }
        return children;
    }

    public List<Integer> getWithinIndexes(TreeSet<Integer> indexes) {
        SortedSet<Integer> withinSet = indexes.subSet(this._start + 1, this._end - 1);
        ArrayList<Integer> children = new ArrayList<Integer>(withinSet);
        return children;
    }

    public Range getInside() {
        if (this._size <= 2L) {
            return NONE;
        }
        return new Range(this._start + 1, this._end - 1);
    }

    public Integer[] getRandomIndexes() {
        Asserts.assertAllFalse(this._start == NEGATIVE_INFINITY, this._end == POSITIVE_INFINITY);
        int size = Math.toIntExact(this._size);
        ArrayList<Integer> list = new ArrayList<Integer>();
        Random random = new Random();
        int count = 0;
        int current = this._start;
        while (current < this._end) {
            list.add(count == 0 ? 0 : random.nextInt(count + 1), current);
            ++current;
            ++count;
        }
        return list.toArray(new Integer[size]);
    }

    public CharSequence subSequence(CharSequence charSequence) {
        Asserts.assertAllNotNull(charSequence, new CharSequence[0]);
        Asserts.assertAllTrue(Range.withinLength(this, charSequence.length()), new boolean[0]);
        return charSequence.subSequence(this._start, this._end);
    }

    public String subString(CharSequence charSequence) {
        return this.subSequence(charSequence).toString();
    }

    @Override
    public int compareTo(Range o) {
        if (o == null) {
            return 1;
        }
        if (this._start == o._start) {
            return o._end - this._end;
        }
        return this._start - o._start;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Range)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        Range other = (Range)obj;
        return this._size == other._size && this._start == other._start;
    }

    public String toString() {
        return String.format("%s, %s", this._start <= NEGATIVE_INFINITY + 1 ? "(\u2212\u221e" : String.format("[%d", this._start), this._end > POSITIVE_INFINITY - 1 ? "+\u221e)" : String.format("%d)", this._end));
    }
}

