/*
 * Decompiled with CFR 0.152.
 */
package io.github.cruisoring.logger;

import io.github.cruisoring.Asserts;
import io.github.cruisoring.logger.ILogger;
import io.github.cruisoring.logger.LogLevel;
import io.github.cruisoring.logger.Logger;
import io.github.cruisoring.logger.Measurement;
import io.github.cruisoring.throwables.RunnableThrowable;
import io.github.cruisoring.throwables.SupplierThrowable;
import java.util.Arrays;
import org.apache.commons.lang3.NotImplementedException;

public class CompositeLogger
implements ILogger {
    final ILogger[] loggers;
    final LogLevel minLevel;

    public CompositeLogger(ILogger ... loggers) {
        this(LogLevel.verbose, loggers);
    }

    public CompositeLogger(LogLevel minLevel, ILogger ... loggers) {
        this.minLevel = Asserts.checkNoneNulls(minLevel, loggers);
        this.loggers = (ILogger[])Arrays.stream(loggers).filter(l -> l != null && !(l instanceof CompositeLogger)).toArray(ILogger[]::new);
    }

    @Override
    public LogLevel getMinLevel() {
        return this.minLevel;
    }

    @Override
    public boolean canLog(LogLevel level) {
        return Logger.getGlobalLogLevel() != LogLevel.none && level.compareTo(this.minLevel) >= 0;
    }

    @Override
    public void save(String message) {
        throw new NotImplementedException("Not supported");
    }

    @Override
    public String getMessage(LogLevel level, String format, Object ... args) {
        throw new NotImplementedException("Not supported");
    }

    @Override
    public <R> R measure(Measurement.Moment startMoment, R value, LogLevel ... level) {
        throw new NotImplementedException("Not supported");
    }

    @Override
    public <R> R measure(Measurement.Moment startMoment, SupplierThrowable<R> supplier, LogLevel ... levels) {
        throw new NotImplementedException("Not supported");
    }

    @Override
    public ILogger measure(Measurement.Moment startMoment, RunnableThrowable runnable, LogLevel ... levels) {
        throw new NotImplementedException("Not supported");
    }

    @Override
    public ILogger log(LogLevel level, String format, Object ... arguments) {
        if (!this.canLog(level)) {
            return this;
        }
        for (ILogger logger : this.loggers) {
            logger.log(level, format, arguments);
        }
        return this;
    }

    @Override
    public ILogger log(LogLevel level, Exception ex) {
        if (!this.canLog(level) || ex == null) {
            return this;
        }
        for (ILogger logger : this.loggers) {
            logger.log(level, ex);
        }
        return this;
    }
}

