/*
 * Decompiled with CFR 0.152.
 */
package io.github.cruisoring.logger;

import io.github.cruisoring.logger.LogLevel;
import io.github.cruisoring.logger.Logger;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.function.Consumer;

public class FileLogger
extends Logger
implements AutoCloseable {
    static final Consumer<String> _do_nothing = s -> {};
    public static String NEW_LINE = "\r\n";
    final File file;
    boolean isValid = true;
    BufferedWriter bufferedWriter = null;

    public FileLogger(String filePath, LogLevel minLevel) {
        super(_do_nothing, minLevel);
        this.file = FileLogger.getFile(filePath);
    }

    public FileLogger(String filePath) {
        this(filePath, LogLevel.verbose);
    }

    static File getFile(String filePath) {
        if (filePath == null) {
            return null;
        }
        return new File(Paths.get(filePath, new String[0]).toString());
    }

    @Override
    public String toString() {
        return String.format("FileLogger of %s or above with '%s'", new Object[]{this.minLevel, this.file});
    }

    @Override
    public boolean canLog(LogLevel level) {
        if (!this.isValid || !super.canLog(level)) {
            return false;
        }
        try {
            if (this.bufferedWriter == null) {
                FileWriter fileWritter = new FileWriter(this.file, true);
                this.bufferedWriter = new BufferedWriter(fileWritter);
            }
        }
        catch (IOException e) {
            this.isValid = false;
        }
        return this.isValid;
    }

    @Override
    public void save(String message) {
        if (!this.isValid) {
            return;
        }
        try {
            if (this.bufferedWriter == null) {
                FileWriter fileWritter = new FileWriter(this.file, true);
                this.bufferedWriter = new BufferedWriter(fileWritter);
            }
            this.bufferedWriter.write(message + NEW_LINE);
            this.bufferedWriter.flush();
        }
        catch (IOException e) {
            this.isValid = false;
        }
    }

    @Override
    public void close() throws Exception {
        if (this.bufferedWriter != null) {
            this.bufferedWriter.flush();
            this.bufferedWriter.close();
        }
    }
}

