/*
 * Decompiled with CFR 0.152.
 */
package io.github.cruisoring.logger;

import io.github.cruisoring.utility.StringHelper;

public interface IWithColor {
    public static final String[] DefaultSuccessKeywords = new String[]{"success", "passed", "pass"};
    public static final String[] DefaultFailedKeywords = new String[]{"fail", "error", "exception", "wrong", "mistake", "problem"};

    public String failPlaceholder();

    public String successPlaceholder();

    public String normalPlaceholder();

    default public boolean isFailed(String format) {
        return StringHelper.containsAnyIgnoreCase(format, DefaultFailedKeywords);
    }

    default public boolean isSuccess(String format) {
        return StringHelper.containsAnyIgnoreCase(format, DefaultSuccessKeywords);
    }

    default public String highlightArgs(String format) {
        String highlighted = this.isFailed(format) ? format.replaceAll("%(\\d*$)?(\\d*)?\\S", this.failPlaceholder()) : (this.isSuccess(format) ? format.replaceAll("%(\\d*$)?(\\d*)?\\S", this.successPlaceholder()) : format.replaceAll("%(\\d*$)?(\\d*)?\\S", this.normalPlaceholder()));
        return highlighted;
    }
}

