/*
 * Decompiled with CFR 0.152.
 */
package io.github.cruisoring.logger;

import io.github.cruisoring.Asserts;
import io.github.cruisoring.Revokable;
import io.github.cruisoring.logger.ConsoleLogger;
import io.github.cruisoring.logger.ILogger;
import io.github.cruisoring.logger.LogLevel;
import io.github.cruisoring.logger.Measurement;
import io.github.cruisoring.throwables.RunnableThrowable;
import io.github.cruisoring.throwables.SupplierThrowable;
import io.github.cruisoring.utility.StringHelper;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.IllegalFormatException;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class Logger
implements ILogger {
    public static ILogger Default = new ConsoleLogger(System.out::println, LogLevel.verbose);
    public static LogLevel DefaultMeasureLogLevel = LogLevel.debug;
    public static final ILogger DoNothing = new Logger(s -> {});
    public static DateTimeFormatter DefaultTimeStampFormatter = DateTimeFormatter.ofPattern("HH:mm:ss.SSS");
    public static String[] DefaultSuccessKeywords = new String[]{"success", "passed", "pass"};
    public static String[] DefaultFailedKeywords = new String[]{"fail", "error", "exception", "wrong", "mistake", "problem"};
    static LogLevel GlobalLogLevel = LogLevel.debug;
    static Object lock = new Object();
    final Consumer<String> recorder;
    final LogLevel minLevel;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LogLevel getGlobalLogLevel() {
        Object object = lock;
        synchronized (object) {
            return GlobalLogLevel;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ILogger getDefault() {
        Object object = lock;
        synchronized (object) {
            return Default;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ILogger setDefault(Logger newLogger) {
        Object object = lock;
        synchronized (object) {
            ILogger oldLogger = Logger.getDefault();
            if (newLogger == null) {
                Default = DoNothing;
            } else if (oldLogger != newLogger) {
                Default = newLogger;
            }
            return oldLogger;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Revokable<ILogger> useInScope(ILogger newLogger) {
        Object object = lock;
        synchronized (object) {
            Revokable<ILogger> revokable = new Revokable<ILogger>(() -> Default, level -> {
                Default = level;
            }, newLogger);
            return revokable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LogLevel setGlobalLevel(LogLevel newLogLevel) {
        Object object = lock;
        synchronized (object) {
            if (newLogLevel == null) {
                return GlobalLogLevel;
            }
            LogLevel oldLevel = GlobalLogLevel;
            if (oldLevel != newLogLevel) {
                GlobalLogLevel = newLogLevel;
            }
            return oldLevel;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Revokable<LogLevel> setLevelInScope(LogLevel newLogLevel) {
        Object object = lock;
        synchronized (object) {
            Revokable<LogLevel> revokable = new Revokable<LogLevel>(() -> GlobalLogLevel, level -> {
                GlobalLogLevel = level;
            }, newLogLevel);
            return revokable;
        }
    }

    public static <R> R M(Measurement.Moment startMoment, R value, LogLevel ... levels) {
        LogLevel level = levels == null || levels.length == 0 ? DefaultMeasureLogLevel : levels[0];
        return Logger.getDefault().measure(startMoment, value, level);
    }

    public static <R> R M(Measurement.Moment startMoment, SupplierThrowable<R> supplier, LogLevel ... levels) {
        LogLevel level = levels == null || levels.length == 0 ? DefaultMeasureLogLevel : levels[0];
        return Logger.getDefault().measure(startMoment, supplier, level);
    }

    public static ILogger M(Measurement.Moment startMoment, RunnableThrowable runnable, LogLevel ... levels) {
        LogLevel level = levels == null || levels.length == 0 ? DefaultMeasureLogLevel : levels[0];
        return Logger.getDefault().measure(startMoment, runnable, level);
    }

    public static ILogger V(Exception ex) {
        return Logger.getDefault().log(LogLevel.verbose, ex);
    }

    public static ILogger D(Exception ex) {
        return Logger.getDefault().log(LogLevel.debug, ex);
    }

    public static ILogger I(Exception ex) {
        return Logger.getDefault().log(LogLevel.info, ex);
    }

    public static ILogger W(Exception ex) {
        return Logger.getDefault().log(LogLevel.warning, ex);
    }

    public static ILogger E(Exception ex) {
        return Logger.getDefault().log(LogLevel.error, ex);
    }

    public static ILogger V(String format, Object ... args) {
        return Logger.getDefault().log(LogLevel.verbose, format, args);
    }

    public static ILogger D(String format, Object ... args) {
        return Logger.getDefault().log(LogLevel.debug, format, args);
    }

    public static ILogger I(String format, Object ... args) {
        return Logger.getDefault().log(LogLevel.info, format, args);
    }

    public static ILogger W(String format, Object ... args) {
        return Logger.getDefault().log(LogLevel.warning, format, args);
    }

    public static ILogger E(String format, Object ... args) {
        return Logger.getDefault().log(LogLevel.error, format, args);
    }

    public Logger(Consumer<String> recorder) {
        this(recorder, LogLevel.verbose);
    }

    public Logger(Consumer<String> recorder, LogLevel minLevel) {
        this.recorder = Asserts.checkNoneNulls(recorder, new Object[]{minLevel});
        this.minLevel = minLevel;
    }

    public String toString() {
        return String.format("Logger of %s or obove.", new Object[]{this.minLevel});
    }

    public boolean isSuccess(String format) {
        return StringHelper.containsAnyIgnoreCase(format, DefaultSuccessKeywords);
    }

    public boolean isFailed(String format) {
        return StringHelper.containsAnyIgnoreCase(format, DefaultFailedKeywords);
    }

    @Override
    public void save(String message) {
        if (this.recorder != null) {
            this.recorder.accept(message);
        }
    }

    @Override
    public LogLevel getMinLevel() {
        return this.minLevel;
    }

    protected String highlightArgs(String format) {
        return format;
    }

    @Override
    public boolean canLog(LogLevel level) {
        return level.compareTo(GlobalLogLevel) >= 0 && level.compareTo(this.minLevel) >= 0;
    }

    @Override
    public int getStackTraceCount(LogLevel level) {
        switch (level) {
            case verbose: {
                return 30;
            }
            case debug: {
                return 15;
            }
            case info: {
                return 10;
            }
            case warning: {
                return -5;
            }
            case error: {
                return -8;
            }
        }
        return 0;
    }

    @Override
    public String getMessage(LogLevel level, String format, Object ... args) {
        String message;
        Asserts.assertAllNotNull(format, new String[0]);
        String label = String.format("[%s%s]: ", level.label, DefaultTimeStampFormatter == null ? "" : "@" + LocalDateTime.now().format(DefaultTimeStampFormatter));
        try {
            message = String.format(format, args);
        }
        catch (IllegalFormatException ex) {
            String argsString = Arrays.stream(args).map(a -> a == null ? "null" : a.toString()).collect(Collectors.joining(", "));
            message = String.format("IllegalFormatException: format='%s', args='%s'", format, argsString);
        }
        return label + message;
    }
}

