/*
 * Decompiled with CFR 0.152.
 */
package io.github.cruisoring.logger;

import io.github.cruisoring.Asserts;
import io.github.cruisoring.logger.LogLevel;
import io.github.cruisoring.logger.Logger;
import io.github.cruisoring.table.Columns;
import io.github.cruisoring.table.IColumns;
import io.github.cruisoring.table.TupleRow;
import io.github.cruisoring.table.TupleTable;
import io.github.cruisoring.throwables.RunnableThrowable;
import io.github.cruisoring.throwables.SupplierThrowable;
import io.github.cruisoring.tuple.Tuple;
import io.github.cruisoring.tuple.Tuple7;
import io.github.cruisoring.utility.ArrayHelper;
import io.github.cruisoring.utility.StackTraceHelper;
import io.github.cruisoring.utility.StringHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;

public class Measurement {
    public static final String START = "start";
    public static final String DURATION = "duration";
    public static final IColumns DefaultColumns = new Columns("start", "duration");
    static final String getCallerStackTraceKey = Measurement.class.getSimpleName() + ".java";
    static final Map<String, TupleTable> namedMeasurements = new LinkedHashMap<String, TupleTable>();

    public static void printMeasurementSummaries(LogLevel level) {
        Map<String, String> performanceSummary = Measurement.getAllSummary();
        for (String name : performanceSummary.keySet()) {
            Logger.Default.log(level, "%s: %s", name, performanceSummary.get(name));
        }
    }

    public static void clear() {
        namedMeasurements.clear();
    }

    public static Moment start(String format, Object ... args) {
        return new Moment(format, args);
    }

    public static Moment start() {
        return new Moment();
    }

    private static Class getClass(Object obj) {
        return obj == null ? Object.class : obj.getClass();
    }

    public static void save(String name, TupleRow details) {
        Asserts.assertAllNotNull(name, details);
        if (!namedMeasurements.containsKey(name)) {
            if (DefaultColumns == details.getColumnIndexes()) {
                TupleTable table = DefaultColumns.createTable(null, Long.class, Long.class);
                namedMeasurements.put(name, table);
            } else {
                List<String> columnNames = details.getColumnIndexes().getColumnNames();
                Class[] classes = (Class[])ArrayHelper.create(Class.class, columnNames.size(), i -> Measurement.getClass(details.getValueByName((String)columnNames.get((int)i))));
                Columns columns = new Columns(columnNames.toArray(new String[0]));
                TupleTable table = columns.createTable(null, classes);
                namedMeasurements.put(name, table);
            }
        }
        namedMeasurements.get(name).addValues(details);
    }

    public static Set<String> getMeasuredNames() {
        return namedMeasurements.keySet();
    }

    public static TupleTable getMeasurements(String name) {
        if (!namedMeasurements.containsKey(name)) {
            return null;
        }
        return namedMeasurements.get(name);
    }

    public static Tuple7<String, Long, Long, Long, Long, Long, Double> defaultSummaryOf(String name) {
        TupleTable table = Measurement.getMeasurements(Asserts.checkNoneNulls(name, new Object[0]));
        if (table == null || !Long.class.equals((Object)table.getColumnElementType(DURATION))) {
            return null;
        }
        Long[] durations = (Long[])table.getColumnValues(DURATION);
        AtomicLong sum = new AtomicLong(0L);
        ArrayList durationList = new ArrayList();
        Arrays.stream(durations).forEach(d -> {
            durationList.add(d);
            sum.getAndAdd((long)d);
        });
        Collections.sort(durationList);
        long total = sum.get();
        int size = durationList.size();
        long mean = total / (long)size;
        long min = (Long)durationList.get(0);
        long max = (Long)durationList.get(size - 1);
        long median = (Long)durationList.get(size / 2);
        double summation = 0.0;
        for (int i = 0; i < size; ++i) {
            long dif = (Long)durationList.get(i) - mean;
            summation += (double)(dif * dif);
        }
        Double standardDeviation = Math.sqrt(summation / (double)size);
        String summary = String.format("%s: <size=%d, mean=%d, median=%d, total=%d, min=%d, max=%d, std=%.2f%%>", name, size, mean, median, total, min, max, standardDeviation);
        return Tuple.create(summary, mean, median, total, min, max, standardDeviation);
    }

    public static Map<String, String> getAllSummary() {
        LinkedHashMap<String, String> summary = new LinkedHashMap<String, String>();
        for (String measurementName : namedMeasurements.keySet()) {
            summary.put(measurementName, (String)Measurement.defaultSummaryOf(measurementName).getFirst());
        }
        return summary;
    }

    public static <R> R measure(String name, int times, SupplierThrowable<R> supplierThrowable, LogLevel ... levels) {
        Asserts.assertAllNotNull(name, supplierThrowable);
        if (namedMeasurements.containsKey(name)) {
            namedMeasurements.get(name).clear();
        }
        R result = null;
        long start = System.currentTimeMillis();
        for (int i = 0; i < times; ++i) {
            result = supplierThrowable.orElse(null).get();
            Measurement.save(name, DefaultColumns.createRow(start, System.currentTimeMillis() - start));
            start = System.currentTimeMillis();
        }
        Tuple7<String, Long, Long, Long, Long, Long, Double> summary = Measurement.defaultSummaryOf(name);
        LogLevel level = levels == null || levels.length == 0 ? Logger.DefaultMeasureLogLevel : levels[0];
        Logger.getDefault().log(level, (String)summary.getFirst(), new Object[0]);
        return result;
    }

    public static void measure(String name, int times, RunnableThrowable runnableThrowable, LogLevel ... levels) {
        Asserts.assertAllNotNull(name, runnableThrowable);
        if (namedMeasurements.containsKey(name)) {
            namedMeasurements.get(name).clear();
        }
        long start = System.currentTimeMillis();
        for (int i = 0; i < times; ++i) {
            runnableThrowable.tryRun();
            Measurement.save(name, DefaultColumns.createRow(start, System.currentTimeMillis() - start));
            start = System.currentTimeMillis();
        }
        Tuple7<String, Long, Long, Long, Long, Long, Double> summary = Measurement.defaultSummaryOf(name);
        LogLevel level = levels == null || levels.length == 0 ? Logger.DefaultMeasureLogLevel : levels[0];
        Logger.getDefault().log(level, (String)summary.getFirst(), new Object[0]);
    }

    public static class Moment {
        final String label;
        final long createdAt;

        Moment() {
            StackTraceElement stack = StackTraceHelper.getCallerStackByEntry(null, getCallerStackTraceKey);
            this.label = StringHelper.tryFormatString("%s(%s:%d)", stack.getMethodName(), stack.getFileName(), stack.getLineNumber());
            this.createdAt = System.currentTimeMillis();
        }

        Moment(String format, Object ... args) {
            this.label = StringHelper.tryFormatString(Asserts.checkNoneNulls(format, new Object[0]), args);
            this.createdAt = System.currentTimeMillis();
        }
    }
}

