/*
 * Decompiled with CFR 0.152.
 */
package io.github.cruisoring.table;

import io.github.cruisoring.Asserts;
import io.github.cruisoring.table.TupleRow;
import io.github.cruisoring.table.TupleRow1;
import io.github.cruisoring.table.TupleRow10;
import io.github.cruisoring.table.TupleRow2;
import io.github.cruisoring.table.TupleRow3;
import io.github.cruisoring.table.TupleRow4;
import io.github.cruisoring.table.TupleRow5;
import io.github.cruisoring.table.TupleRow6;
import io.github.cruisoring.table.TupleRow7;
import io.github.cruisoring.table.TupleRow8;
import io.github.cruisoring.table.TupleRow9;
import io.github.cruisoring.table.TupleRowPlus;
import io.github.cruisoring.table.TupleTable;
import io.github.cruisoring.table.TupleTable1;
import io.github.cruisoring.table.TupleTable10;
import io.github.cruisoring.table.TupleTable2;
import io.github.cruisoring.table.TupleTable3;
import io.github.cruisoring.table.TupleTable4;
import io.github.cruisoring.table.TupleTable5;
import io.github.cruisoring.table.TupleTable6;
import io.github.cruisoring.table.TupleTable7;
import io.github.cruisoring.table.TupleTable8;
import io.github.cruisoring.table.TupleTable9;
import io.github.cruisoring.table.TupleTablePlus;
import io.github.cruisoring.tuple.Tuple;
import io.github.cruisoring.tuple.WithValues;
import io.github.cruisoring.tuple.WithValues1;
import io.github.cruisoring.tuple.WithValues10;
import io.github.cruisoring.tuple.WithValues2;
import io.github.cruisoring.tuple.WithValues3;
import io.github.cruisoring.tuple.WithValues4;
import io.github.cruisoring.tuple.WithValues5;
import io.github.cruisoring.tuple.WithValues6;
import io.github.cruisoring.tuple.WithValues7;
import io.github.cruisoring.tuple.WithValues8;
import io.github.cruisoring.tuple.WithValues9;
import io.github.cruisoring.tuple.WithValuesPlus;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;

public interface IColumns
extends Map<String, Integer> {
    public Comparator<String> getNameComparator();

    public List<String> getColumnNames();

    public int width();

    public Map<String, Integer> getColumnIndexes();

    public String[][] getIndexedColumns();

    @Override
    default public Integer get(Object key) {
        if (key == null || !(key instanceof String)) {
            return -1;
        }
        String keyString = (String)key;
        Set keySet = this.keySet();
        if (keySet.contains(keyString)) {
            return this.getColumnIndexes().get(keyString);
        }
        Comparator<String> nameComparator = this.getNameComparator();
        for (String k : keySet) {
            if (nameComparator.compare(k, keyString) != 0) continue;
            return this.getColumnIndexes().get(k);
        }
        return -1;
    }

    default public WithValues2<Integer, Integer> mapIndexes(String columnName, IColumns other) {
        Integer thisIndex = this.get(Asserts.checkNoneNulls(columnName, new Object[0]));
        if (thisIndex == -1) {
            return null;
        }
        if (other == this) {
            return Tuple.create(thisIndex, thisIndex);
        }
        Integer otherIndex = other.get(columnName);
        if (otherIndex == -1) {
            return null;
        }
        return Tuple.create(thisIndex, otherIndex);
    }

    public WithValues<Integer> mapIndexes(IColumns var1);

    default public TupleRow createRow(Object ... elements) {
        Asserts.assertAllTrue(elements != null, new boolean[0]);
        int length = elements.length;
        switch (length) {
            case 0: {
                return new TupleRow(this, Tuple.UNIT);
            }
            case 1: {
                return new TupleRow1<Object>(this, elements[0]);
            }
            case 2: {
                return new TupleRow2<Object, Object>(this, elements[0], elements[1]);
            }
            case 3: {
                return new TupleRow3<Object, Object, Object>(this, elements[0], elements[1], elements[2]);
            }
            case 4: {
                return new TupleRow4<Object, Object, Object, Object>(this, elements[0], elements[1], elements[2], elements[3]);
            }
            case 5: {
                return new TupleRow5<Object, Object, Object, Object, Object>(this, elements[0], elements[1], elements[2], elements[3], elements[4]);
            }
            case 6: {
                return new TupleRow6<Object, Object, Object, Object, Object, Object>(this, elements[0], elements[1], elements[2], elements[3], elements[4], elements[5]);
            }
            case 7: {
                return new TupleRow7<Object, Object, Object, Object, Object, Object, Object>(this, elements[0], elements[1], elements[2], elements[3], elements[4], elements[5], elements[6]);
            }
            case 8: {
                return new TupleRow8<Object, Object, Object, Object, Object, Object, Object, Object>(this, elements[0], elements[1], elements[2], elements[3], elements[4], elements[5], elements[6], elements[7]);
            }
            case 9: {
                return new TupleRow9<Object, Object, Object, Object, Object, Object, Object, Object, Object>(this, elements[0], elements[1], elements[2], elements[3], elements[4], elements[5], elements[6], elements[7], elements[8]);
            }
            case 10: {
                return new TupleRow10<Object, Object, Object, Object, Object, Object, Object, Object, Object, Object>(this, elements[0], elements[1], elements[2], elements[3], elements[4], elements[5], elements[6], elements[7], elements[8], elements[9]);
            }
        }
        return new TupleRowPlus<Object, Object, Object, Object, Object, Object, Object, Object, Object, Object>(this, elements[0], elements[1], elements[2], elements[3], elements[4], elements[5], elements[6], elements[7], elements[8], elements[9], Arrays.copyOfRange(elements, 10, length));
    }

    default public TupleRow asRow(WithValues tuple) {
        int length = Asserts.checkNoneNulls(tuple, new Object[0]).getLength();
        if (length == 0) {
            throw new UnsupportedOperationException("No columns defined");
        }
        switch (length) {
            case 1: {
                return this.asRow1((WithValues1)tuple);
            }
            case 2: {
                return this.asRow2((WithValues2)tuple);
            }
            case 3: {
                return this.asRow3((WithValues3)tuple);
            }
            case 4: {
                return this.asRow4((WithValues4)tuple);
            }
            case 5: {
                return this.asRow5((WithValues5)tuple);
            }
            case 6: {
                return this.asRow6((WithValues6)tuple);
            }
            case 7: {
                return this.asRow7((WithValues7)tuple);
            }
            case 8: {
                return this.asRow8((WithValues8)tuple);
            }
            case 9: {
                return this.asRow9((WithValues9)tuple);
            }
            case 10: {
                return this.asRow10((WithValues10)tuple);
            }
        }
        return this.asRowPlus((WithValuesPlus)tuple);
    }

    default public <T> TupleRow1<T> asRow1(WithValues1<T> tuple) {
        return new TupleRow1<WithValues1<T>>(this, tuple);
    }

    default public <T, U> TupleRow2<T, U> asRow2(WithValues2<T, U> tuple) {
        return new TupleRow2<T, U>(this, tuple);
    }

    default public <T, U, V> TupleRow3<T, U, V> asRow3(WithValues3<T, U, V> tuple) {
        return new TupleRow3<T, U, V>(this, tuple);
    }

    default public <T, U, V, W> TupleRow4<T, U, V, W> asRow4(WithValues4<T, U, V, W> tuple) {
        return new TupleRow4<T, U, V, W>(this, tuple);
    }

    default public <T, U, V, W, X> TupleRow5<T, U, V, W, X> asRow5(WithValues5<T, U, V, W, X> tuple) {
        return new TupleRow5<T, U, V, W, X>(this, tuple);
    }

    default public <T, U, V, W, X, Y> TupleRow6<T, U, V, W, X, Y> asRow6(WithValues6<T, U, V, W, X, Y> tuple) {
        return new TupleRow6<T, U, V, W, X, Y>(this, tuple);
    }

    default public <T, U, V, W, X, Y, Z> TupleRow7<T, U, V, W, X, Y, Z> asRow7(WithValues7<T, U, V, W, X, Y, Z> tuple) {
        return new TupleRow7<T, U, V, W, X, Y, Z>(this, tuple);
    }

    default public <T, U, V, W, X, Y, Z, A> TupleRow8<T, U, V, W, X, Y, Z, A> asRow8(WithValues8<T, U, V, W, X, Y, Z, A> tuple) {
        return new TupleRow8<T, U, V, W, X, Y, Z, A>(this, tuple);
    }

    default public <T, U, V, W, X, Y, Z, A, B> TupleRow9<T, U, V, W, X, Y, Z, A, B> asRow9(WithValues9<T, U, V, W, X, Y, Z, A, B> tuple) {
        return new TupleRow9<T, U, V, W, X, Y, Z, A, B>(this, tuple);
    }

    default public <T, U, V, W, X, Y, Z, A, B, C> TupleRow10<T, U, V, W, X, Y, Z, A, B, C> asRow10(WithValues10<T, U, V, W, X, Y, Z, A, B, C> tuple) {
        return new TupleRow10<T, U, V, W, X, Y, Z, A, B, C>(this, tuple);
    }

    default public <T, U, V, W, X, Y, Z, A, B, C> TupleRowPlus<T, U, V, W, X, Y, Z, A, B, C> asRowPlus(WithValuesPlus<T, U, V, W, X, Y, Z, A, B, C> tuple) {
        return new TupleRowPlus<T, U, V, W, X, Y, Z, A, B, C>(this, tuple);
    }

    default public TupleTable createTable(Supplier<List<WithValues>> rowsSupplier, Class ... types) {
        Asserts.assertAllNotNull(types, new Class[0][]);
        int length = types.length;
        switch (length) {
            case 0: {
                return new TupleTable(rowsSupplier, this, new Class[0]);
            }
            case 1: {
                return new TupleTable1(rowsSupplier, this, types[0]);
            }
            case 2: {
                return new TupleTable2(rowsSupplier, this, types[0], types[1]);
            }
            case 3: {
                return new TupleTable3(rowsSupplier, this, types[0], types[1], types[2]);
            }
            case 4: {
                return new TupleTable4(rowsSupplier, this, types[0], types[1], types[2], types[3]);
            }
            case 5: {
                return new TupleTable5(rowsSupplier, this, types[0], types[1], types[2], types[3], types[4]);
            }
            case 6: {
                return new TupleTable6(rowsSupplier, this, types[0], types[1], types[2], types[3], types[4], types[5]);
            }
            case 7: {
                return new TupleTable7(rowsSupplier, this, types[0], types[1], types[2], types[3], types[4], types[5], types[6]);
            }
            case 8: {
                return new TupleTable8(rowsSupplier, this, types[0], types[1], types[2], types[3], types[4], types[5], types[6], types[7]);
            }
            case 9: {
                return new TupleTable9(rowsSupplier, this, types[0], types[1], types[2], types[3], types[4], types[5], types[6], types[7], types[8]);
            }
            case 10: {
                return new TupleTable10(rowsSupplier, this, types[0], types[1], types[2], types[3], types[4], types[5], types[6], types[7], types[8], types[9]);
            }
        }
        return new TupleTablePlus(rowsSupplier, this, types[0], types[1], types[2], types[3], types[4], types[5], types[6], types[7], types[8], types[9], (Type[])Arrays.copyOfRange(types, 10, length));
    }

    default public <T> TupleTable1<T> createTable1(Class<? extends T> typeT) {
        return new TupleTable1<T>(null, this, typeT);
    }

    default public <T, U> TupleTable2<T, U> createTable2(Class<? extends T> typeT, Class<? extends U> typeU) {
        return new TupleTable2<T, U>(null, this, typeT, typeU);
    }

    default public <T, U, V> TupleTable3<T, U, V> createTable3(Class<? extends T> typeT, Class<? extends U> typeU, Class<? extends V> typeV) {
        return new TupleTable3<T, U, V>(null, this, typeT, typeU, typeV);
    }

    default public <T, U, V, W> TupleTable4<T, U, V, W> createTable4(Class<? extends T> typeT, Class<? extends U> typeU, Class<? extends V> typeV, Class<? extends W> typeW) {
        return new TupleTable4<T, U, V, W>(null, this, typeT, typeU, typeV, typeW);
    }

    default public <T, U, V, W, X> TupleTable5<T, U, V, W, X> createTable5(Class<? extends T> typeT, Class<? extends U> typeU, Class<? extends V> typeV, Class<? extends W> typeW, Class<? extends X> typeX) {
        return new TupleTable5<T, U, V, W, X>(null, this, typeT, typeU, typeV, typeW, typeX);
    }

    default public <T, U, V, W, X, Y> TupleTable6<T, U, V, W, X, Y> createTable6(Class<? extends T> typeT, Class<? extends U> typeU, Class<? extends V> typeV, Class<? extends W> typeW, Class<? extends X> typeX, Class<? extends Y> typeY) {
        return new TupleTable6<T, U, V, W, X, Y>(null, this, typeT, typeU, typeV, typeW, typeX, typeY);
    }

    default public <T, U, V, W, X, Y, Z> TupleTable7<T, U, V, W, X, Y, Z> createTable7(Class<? extends T> typeT, Class<? extends U> typeU, Class<? extends V> typeV, Class<? extends W> typeW, Class<? extends X> typeX, Class<? extends Y> typeY, Class<? extends Z> typeZ) {
        return new TupleTable7<T, U, V, W, X, Y, Z>(null, this, typeT, typeU, typeV, typeW, typeX, typeY, typeZ);
    }

    default public <T, U, V, W, X, Y, Z, A> TupleTable8<T, U, V, W, X, Y, Z, A> createTable8(Class<? extends T> typeT, Class<? extends U> typeU, Class<? extends V> typeV, Class<? extends W> typeW, Class<? extends X> typeX, Class<? extends Y> typeY, Class<? extends Z> typeZ, Class<? extends A> typeA) {
        return new TupleTable8<T, U, V, W, X, Y, Z, A>(null, this, typeT, typeU, typeV, typeW, typeX, typeY, typeZ, typeA);
    }

    default public <T, U, V, W, X, Y, Z, A, B> TupleTable9<T, U, V, W, X, Y, Z, A, B> createTable9(Class<? extends T> typeT, Class<? extends U> typeU, Class<? extends V> typeV, Class<? extends W> typeW, Class<? extends X> typeX, Class<? extends Y> typeY, Class<? extends Z> typeZ, Class<? extends A> typeA, Class<? extends B> typeB) {
        return new TupleTable9<T, U, V, W, X, Y, Z, A, B>(null, this, typeT, typeU, typeV, typeW, typeX, typeY, typeZ, typeA, typeB);
    }

    default public <T, U, V, W, X, Y, Z, A, B, C> TupleTable10<T, U, V, W, X, Y, Z, A, B, C> createTable10(Class<? extends T> typeT, Class<? extends U> typeU, Class<? extends V> typeV, Class<? extends W> typeW, Class<? extends X> typeX, Class<? extends Y> typeY, Class<? extends Z> typeZ, Class<? extends A> typeA, Class<? extends B> typeB, Class<? extends C> typeC) {
        return new TupleTable10<T, U, V, W, X, Y, Z, A, B, C>(null, this, typeT, typeU, typeV, typeW, typeX, typeY, typeZ, typeA, typeB, typeC);
    }

    default public <T, U, V, W, X, Y, Z, A, B, C> TupleTablePlus<T, U, V, W, X, Y, Z, A, B, C> createTablePlus(Class<? extends T> typeT, Class<? extends U> typeU, Class<? extends V> typeV, Class<? extends W> typeW, Class<? extends X> typeX, Class<? extends Y> typeY, Class<? extends Z> typeZ, Class<? extends A> typeA, Class<? extends B> typeB, Class<? extends C> typeC, Type ... moreTypes) {
        return new TupleTablePlus<T, U, V, W, X, Y, Z, A, B, C>(null, this, typeT, typeU, typeV, typeW, typeX, typeY, typeZ, typeA, typeB, typeC, moreTypes);
    }
}

