/*
 * Decompiled with CFR 0.152.
 */
package io.github.cruisoring.throwables;

import io.github.cruisoring.ofThrowable;
import io.github.cruisoring.throwables.RunnableThrowable;
import java.util.function.BiConsumer;
import java.util.function.Function;

@FunctionalInterface
public interface BiConsumerThrowable<T, U>
extends ofThrowable {
    public void accept(T var1, U var2) throws Exception;

    default public void tryAccept(T t, U u) {
        try {
            this.accept(t, u);
        }
        catch (Exception cause) {
            this.handle(cause);
        }
    }

    default public RunnableThrowable asRunnableThrowable(T t, U u) {
        return () -> this.accept(t, u);
    }

    default public BiConsumer<T, U> withHandler(Function<Exception, Object> ... exceptionHandlers) {
        if (exceptionHandlers == null || exceptionHandlers.length == 0) {
            return this::tryAccept;
        }
        BiConsumer<Object, Object> function = (t, u) -> {
            try {
                this.accept(t, u);
            }
            catch (Exception e) {
                exceptionHandlers[0].apply(e);
            }
        };
        return function;
    }
}

