/*
 * Decompiled with CFR 0.152.
 */
package io.github.cruisoring.throwables;

import io.github.cruisoring.ofThrowable;
import io.github.cruisoring.throwables.SupplierThrowable;
import java.util.function.BiPredicate;
import java.util.function.Function;

@FunctionalInterface
public interface BiPredicateThrowable<T, U>
extends ofThrowable<Boolean> {
    public boolean test(T var1, U var2) throws Exception;

    default public boolean tryTest(T t, U u) {
        try {
            return this.test(t, u);
        }
        catch (Exception e) {
            return (Boolean)this.handle(e);
        }
    }

    default public SupplierThrowable<Boolean> asSupplierThrowable(T t, U u) {
        return () -> this.test(t, u);
    }

    default public BiPredicate<T, U> withHandler(Function<Exception, Object> ... exceptionHandlers) {
        if (exceptionHandlers == null || exceptionHandlers.length == 0) {
            return this::tryTest;
        }
        BiPredicate<Object, Object> predicate = (t, u) -> {
            try {
                return this.test(t, u);
            }
            catch (Exception e) {
                return (Boolean)exceptionHandlers[0].apply(e);
            }
        };
        return predicate;
    }

    default public BiPredicate<T, U> orElse(boolean defaultValue) {
        BiPredicate<Object, Object> predicate = (t, u) -> {
            try {
                return this.test(t, u);
            }
            catch (Exception e) {
                return defaultValue;
            }
        };
        return predicate;
    }
}

