/*
 * Decompiled with CFR 0.152.
 */
package io.github.cruisoring.throwables;

import io.github.cruisoring.ofThrowable;
import io.github.cruisoring.throwables.SupplierThrowable;
import java.util.function.Function;

@FunctionalInterface
public interface QuadFunctionThrowable<T, U, V, W, R>
extends ofThrowable<R> {
    public R apply(T var1, U var2, V var3, W var4) throws Exception;

    default public R tryApply(T t, U u, V v, W w) {
        try {
            return this.apply(t, u, v, w);
        }
        catch (Exception e) {
            return this.handle(e);
        }
    }

    default public SupplierThrowable<R> asSupplierThrowable(T t, U u, V v, W w) {
        return () -> this.apply(t, u, v, w);
    }

    default public QuadFunction<T, U, V, W, R> withHandler(Function<Exception, Object> ... exceptionHandlers) {
        if (exceptionHandlers == null || exceptionHandlers.length == 0) {
            return this::tryApply;
        }
        QuadFunction<Object, Object, Object, Object, Object> function = (t, u, v, w) -> {
            try {
                return this.apply(t, u, v, w);
            }
            catch (Exception e) {
                return exceptionHandlers[0].apply(e);
            }
        };
        return function;
    }

    default public QuadFunction<T, U, V, W, R> orElse(R defaultValue) {
        QuadFunction<Object, Object, Object, Object, Object> function = (t, u, v, w) -> {
            try {
                return this.apply(t, u, v, w);
            }
            catch (Exception e) {
                return defaultValue;
            }
        };
        return function;
    }

    @FunctionalInterface
    public static interface QuadFunction<T, U, V, W, R> {
        public R apply(T var1, U var2, V var3, W var4);
    }
}

