/*
 * Decompiled with CFR 0.152.
 */
package io.github.cruisoring.throwables;

import io.github.cruisoring.logger.Logger;
import io.github.cruisoring.ofThrowable;
import java.util.function.Function;
import java.util.function.Supplier;

@FunctionalInterface
public interface SupplierThrowable<R>
extends ofThrowable<R> {
    public R get() throws Exception;

    default public R tryGet() {
        try {
            return this.get();
        }
        catch (Exception e) {
            return this.handle(e);
        }
    }

    default public Supplier<R> withHandler(Function<Exception, Object> ... exceptionHandlers) {
        if (exceptionHandlers == null || exceptionHandlers.length == 0) {
            return this::tryGet;
        }
        Supplier<Object> supplier = () -> {
            try {
                return this.get();
            }
            catch (Exception e) {
                return exceptionHandlers[0].apply(e);
            }
        };
        return supplier;
    }

    default public Supplier<R> orElse(R defaultValue) {
        Supplier<Object> supplier = () -> {
            try {
                return this.get();
            }
            catch (Exception e) {
                Logger.D(e);
                return defaultValue;
            }
        };
        return supplier;
    }
}

