/*
 * Decompiled with CFR 0.152.
 */
package io.github.cruisoring.throwables;

import io.github.cruisoring.ofThrowable;
import io.github.cruisoring.throwables.SupplierThrowable;
import java.util.function.Function;

@FunctionalInterface
public interface TriFunctionThrowable<T, U, V, R>
extends ofThrowable<R> {
    public R apply(T var1, U var2, V var3) throws Exception;

    default public R tryApply(T t, U u, V v) {
        try {
            return this.apply(t, u, v);
        }
        catch (Exception e) {
            return this.handle(e);
        }
    }

    default public SupplierThrowable<R> asSupplierThrowable(T t, U u, V v) {
        return () -> this.apply(t, u, v);
    }

    default public TriFunction<T, U, V, R> withHandler(Function<Exception, Object> ... exceptionHandlers) {
        if (exceptionHandlers == null || exceptionHandlers.length == 0) {
            return this::tryApply;
        }
        TriFunction<Object, Object, Object, Object> function = (t, u, v) -> {
            try {
                return this.apply(t, u, v);
            }
            catch (Exception e) {
                return exceptionHandlers[0].apply(e);
            }
        };
        return function;
    }

    default public TriFunction<T, U, V, R> orElse(R defaultValue) {
        TriFunction<Object, Object, Object, Object> function = (t, u, v) -> {
            try {
                return this.apply(t, u, v);
            }
            catch (Exception e) {
                return defaultValue;
            }
        };
        return function;
    }

    @FunctionalInterface
    public static interface TriFunction<T, U, V, R> {
        public R apply(T var1, U var2, V var3);
    }
}

